
/* AMX Mod script.
* 
* (c) Copyright 2002, OLO
* This file is provided as is (no warranties). 
* 2003/09/27 thomastj Altered to work with Steam
* 2005/11/28 Gunny Updated to use cfg file
*/    

#include <amxmodx>
#include <amxmisc>

/*****************************************************************
 
 Protect your clan tag on your server!

 1. Create a file named clan.cfg  and place it in your /addons/amxmodx/configs folder
 
 2. Then add each members Steamid and the Clan Tag you want protected. One per line
 
  Example of your clan.cfg:
 
	amx_protclantag "mytag" "STEAM_0:0:123142"
	amx_protclantag "mytag" "STEAM_0:0:654645"
	amx_protclantag "mytag" "STEAM_0:0:457457"
	amx_protclantag "anothertag" "STEAM_0:0:9988989"
	amx_protclantag "anothertag" "STEAM_0:0:23432"
	amx_protclantag "anothertag" "STEAM_0:0:120032"

 3. Now add the following to your amxx.cfg:
 
     exec /addons/amxmodx/configs/clan.cfg   // Clan.cfg

********************************************************************
*/

#define CLANTAGD

/* Max. number of entries */
#define MAX_CLANTAGS 200

new clantaglist[MAX_CLANTAGS][32]
new authids[MAX_CLANTAGS][32]
new num_clantags
new bool:cancheck[33]

public add_clantag(id,level,cid){
	if (!cmd_access(id,level,cid,3))
		return PLUGIN_HANDLED
	if (num_clantags >= MAX_CLANTAGS){
		console_print(id,"Max. number of %d entries reached. Can't add more clan tags",MAX_CLANTAGS)
		return PLUGIN_HANDLED
	}
	read_argv(1,clantaglist[num_clantags],31)
	read_argv(2,authids[num_clantags],31)
	console_print(id,"Protection for clan tag ^"%s^" set steamID ^"%s^" ",clantaglist[num_clantags],authids[num_clantags])
        num_clantags++
	return PLUGIN_HANDLED
}        

// check authid with given clantag
cant_use_tag(id,clantag[]){
	new authid[32]
	get_user_authid(id,authid,31)
#if defined CLANTAGD
        log_message("[CLANTAG] Authenticating tag: ^"%s^" steamID: ^"%s^"",clantag,authid)
#endif
        // If steam id still not assigned then redrive the client entered code and exit here 

        if ( (equal(authid,"STEAM_ID_PENDING")) || (equal(authid,"")) ) 
          {
            set_task(0.5,"client_entered",id)
            return false
          } 
	for (new i=0; i<num_clantags; ++i){
		if ( equal(clantag,clantaglist[i]) && equal(authid,authids[i]) )
                   return false
	}
#if defined CLANTAGD
        log_message("[CLANTAG] Unauthorized tag: ^"%s^" steamID: ^"%s^"",clantag,authid)
#endif
	return true
}

check_name(id,name[]) {
	for (new i=0; i<num_clantags; ++i){
		if (containi(name,clantaglist[i]) != -1){
			if (cant_use_tag(id,clantaglist[i])){
				client_cmd(id,"echo ^"* Name '%s' is protected on this server, you cannot use it!^";disconnect",clantaglist[i])
				client_print(0,print_chat,"* %s kicked from server, name '%s' is protected", name,clantaglist[i])
#if defined CLANTAGD
				log_message("[CLANTAG] %s kicked from server, name '%s' is protected", name,clantaglist[i])
#endif
                                cancheck[id] = false
				return PLUGIN_HANDLED
			}
			break
		}
	}
	return PLUGIN_CONTINUE
}

/* catch clients connecting and check names & clan tags */
public client_putinserver(id)
        set_task(0.5,"client_entered",id)

public client_entered(id){
	cancheck[id] = true
	new name[32]
	get_user_name(id,name,31)
#if defined CLANTAGD
        log_message("[CLANTAG] Client entered ^"%s^"",name)
#endif
        return check_name(id,name)
}

/* detect name change against protected list */
public client_infochanged(id){
	if (cancheck[id]){ /* to exclude double checking when player is dead and name is switched back by CS */
		new name[32]
		get_user_info(id,"name",name,31)
#if defined CLANTAGD
                log_message("[CLANTAG] Name change ^"%s^"",name)
#endif
		return check_name(id,name)
	}
	return PLUGIN_CONTINUE
}

public plugin_init() {
   register_plugin("Clan Tag Protection","0.9.9","Gunny")
   register_concmd("amx_protclantag","add_clantag",ADMIN_LEVEL_A,"<clan tag> <authid>")
   return PLUGIN_CONTINUE
}

