//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Battlefield 2 Rank Mod by pRED* - anaconda.182@gmail.com
//
//	An attempt to recreate the battlefield ranking system onto cs1.6
//	Currently features the basics of the ranking system, with no power up gain recieved from leveling.
//	
//	Ranks are based on the number of kills from the csstats system
//	
//	Badges can also be earned to get power up bonuses - See rewards list. Or look at /bf2menu in game
//	
//
//	Wish list: 	Add some more badges maybe? Ive put some ideas in comments...
//			Rank pictures..
//
//	Known Bugs	General optimisation stuff - Ive done most in the wiki tut but there may be more
//	
//	Rewards:	Knife - 20/40/60% of damage done with knife returned to player.
//			Support - Recoil with M249 reduced 1/3,1/2,Full
//			Pistol - Chance of stopping opponent when u get shot (not sure if its working..)
//			Assault - 10/20/30 Bonus HP when spawning
//			Sniper - 1/3,1/2,Full Chance of Free awp/scout
//			Explosives - Free Grenade/Free Defuse Kit/Free Full nade set
//
//	Credits:	Xuntric and PM for their combined work on the XP based plugin tutorial (load, save and menu stuff..)
//			Avalanche for the removed cone of fire in i_aim_good plugin (used for lowered recoil on the para)
//			Phantom Warrior and palehorse for inadvertently giving me the idea for this (Military Rank Mod thread..)
//			ev0d00b cos I stole lots of code out of his/our Capture the Hax Plugin
//			Ubernet (games.uber.net.nz) for giving me a test server and help test the mod
//			stupok69 for helping fix the /whois command
//			Geesu for all his defined cs weapon speeds used in wc3ft (resetting users speed after imobilising them),
//			and some great examples of screen flashes and shakes.
//			Cheap_Suit for the extra recoil code
//			Hawk522 for his tutorial on SQLx (and helping me debug problems with it)
//			styremelaker for massive amount of csdm testing.
//			vittu for going through the code and finding heaps of mistakes and efficiency changes
//			teamme06 for his colorchat code
//			vittu again for supporting my plugin more than I do..
//			BlueRaja for player kills and score update code from his damage multiplier plugin (big copy, paste of the kill function)
//			palehorse for the web html documents
//			vittu for testing and helping fix bugs in the code.
//			emp' for the new amxx menu tutorial
//
//	Cvars:		bf2_active (1|0) - Turns the plugin on or off - Default 1
//			bf2_badges (1|0) - Turns the badge system on or off - Default 1
//			bf2_awp (1|0) - Is user given an awp or scout by having the sniper badge - Default 0 (scout)
//			bf2_xpmultiplier (1|0) - Changes the kill multiplier needed to reach each level - Default 0.1 (15 kills for rank 1, 20k kills for top rank)
//			bf2_sql (1|0) - Turns Switches between SQL and vault saving - Default 1 (SQL)
//			bf2_icon_time (float) - Time (in seconds) to show the rank icon above peoples heads 0=disabled. default 1.5
//			bf2_flag_kills (int) - CS flags - How many bf2 points are awarded for capturing a flag
//			bf2_flag_round_kills - CS flags - How many bf2 points are awarded for winning a round
//			bf2_flag_match_kills  - CS flags - How many bf2 points are awarded for winning the match
//			bf2_flag_min_players - CS flags - Min number of plays before above points get awarded
//			bf2_help_url (string) - remote folder where the bf2 web docs are stored (optional) do not include the trailing /
//			bf2_badgepowers (1|0) - enable/disable the powers for the badgess
//			bf2_hud_options "abcde"
//				a Display Health/Armour/Weapon for teammates
//				b Display Rank for teammates
//				c Display Rank for enemies
//				d Hide display for invisible enemies
//				e Move the display to above peoples heads
//
//
//	Cmds:		say /bf2menu - Shows the Main Menu
//			say /who - Shows a list of player and their rank
//			say /whois <name> - Show the rank and badges of a specific player
//			say /whostats <name> - Show the stats page for a player
//			say /hud - Redisplays the HUD
//			say /ranks - Shows the kill xp table
//			say /bf2stats - your personal stats pages
//			say /help - Displays a Help MOTD
//			say /badges1 - Displays a Help MOTD on some of the badges
//			say /badges2 - Displays a Help MOTD on the rest of the badges
//			say /badges3 - Badges 3
//			bf2_addbagde <player> <badge> <level> - Gives a badge to player. Requires Ban admin access. Badge <0-5>. Level <0-3>
//			bf2_addkills <player> <kills> - Adds to a players kills.. Also requires ban access
//
//	Changes:	1.1 - 	Fixed Bug with Veteran Assault badge
//				Added SQL support (bf2_sql 1)
//				Changed support badge to bonus speed (added code for extra damage, recoil - will finish when amxx 1.77 is released)
//				Sounds, Screen Shake, User glows..
//			1.2 - 	Massive change to make global kill counting actually work..
//				Added screen to view weapon stats "say /bf2stats" or use the menu
//				Added concmd "bf2_vaultload" to forcibly load your own data from the vault (im using it to convert my stats from vault to sql)
//				Tell people to type bf2_vaultload into console and their badges will be restored. Other than that probably a useless command
//			1.21 -	Added a badge check 5 seconds before map changes.
//			1.22 -  bf2_addbadge admin command added
//			1.23 -  Added CSDM functionality. Give hp/weapons on all spawns. 
//				Recoded badge checking to be individual on player death
//				Fixed HP bug and added message "beginning badge check"
//			1.30 -	Starting work on 4 New ranks
//				Shows Teammates rank when you look at them.
//				Give 50,100,200 armour for having 6,12 or 18 badges..
//				Bf2 now saves totalkills itself. Prevents csstats resets..
//				bf2_addkills (admin abuse tool? - or to reset after csstats reset), gives x kills to a player
//				Reduced the amount of saving to vault - causing server lag.
//				Changed to nVault saving. Now uses only 1 vault data instead of 14.
//				Fixed armour being lower than you had before
//				Split file into large set of includes. Way easier to find functions you want.
//				Added +3 kills for defuse/explode. Cs flags mod support
//			1.31 -	Lowered chance of imobilising happening.
//				Changed damage event and bomb events to the csx forward versions and created a csx forward include
//				Capped knife badge damage to 130
//				Removed bf2_vaultload (pointless now.)
//				Fixed some spelling newbie mistakes..
//				Fixed immunity problems
//				Moved inl and config files into their own folder..
//				Probably a few other things too..
//			1.4 -	Fixed wrong sprites displaying
//				fixed double hp gain on round reset (CSDM)
//				added /whostats command
//				bf2_help_url (and web motds) and bf2_badgepowers cvars
//				fixed sprites
//				CSDM badges not being awarded.
//				Top ranked in server display message
//				New menus
//				reset your stats command
//				Medals other new stats
//				Logging admin commands
//				Two new badges. Fixed Explosives badge for csdm
//				Heaps of new stats options + saving them (server and player)
//				Changed power for support
//				SQL now a defined option
//				Moved needed fakemeta_util functions into a separate file (included)
//				New HUD system thanks to vittu (added cvar to control it)
//				bf2_reset_days cvar - number of days without playing till xp gets reset
//				
//
//
//	Requires: Fakemeta, Csstats, fakemeta_util
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <amxmodx>
#include <amxmisc>
#include <amxconst>
#include <csstats>
#include <cstrike>
#include <fakemeta>
#include "bf2/fakemeta_util_mini.inl"
#include <csx>
#include <fun>

#define ADMIN_LEVEL ADMIN_BAN
#define ADMIN_RESET ADMIN_CFG

new const PLUGIN[] = "Battlefield2 Rank Mod"
new const AUTHOR[] = "pRED*"
new const VERSION[] = "1.4"

//Compile Settings

#define CSDM
//#define SQL

//Message sending variables
new gmsgStatusText;
new gmsgScreenFade;
new gmsgScreenShake;
new gmsgDeathMsg;
new gmsgScoreInfo;
new gmsgSayText;

new g_status_sync;


#define MAX_RANKS 17
#define MAX_BADGES 8

//Motd variables
new configsdir[200]
new configfile[200]

//Cvar vars
new g_bf2_active;
new g_badges_active;
new g_free_awp;
new g_xp_multiplier;
new g_icon_hold;
new g_flag_kills;
new g_help_url;
new g_powers;
new g_flag_round_kills
new g_flag_match_kills
new g_flag_min_players
new g_hud_options
new g_prune_days

//Current players info
new g_PlayerRank[33];
new g_PlayerBadges[33][MAX_BADGES];
new knifekills[33];
new pistolkills[33];
new sniperkills[33];
new parakills[33];
new defuses[33];
new plants[33];
new explosions[33];
new accuracy[33];
new totalkills[33];
new authid[33][32];
new smgkills[33];
new shotgunkills[33];
new riflekills[33];
new grenadekills[33];

new bronze[33];
new silver[33];
new gold[33];



//Temp storage variables
new nextrank[33];
new numofbadges[33];
new bool:newplayer[33];
new g_lastwpn[33]
//new g_lastclip[33]
new bool:imobile[33];
new bool:freezetime;
new highestrank
new highestrankid
new statsloaded[33]


new g_friend[33];
new g_invis[33];

new menuselection[33];

//Server stats
new highestrankserver
new highestrankservername[30]

new mostkills
new mostkillsid
new mostkillsname[30]

new mostwins
new mostwinsname[30]


new menuselected[33][3];
//0 - Badge/Kills selected 0/1
//1 - Badgenum/Kills
//2 - Badgelevel

//Sound Vars
new g_Sound1[] = "buttons/bell1.wav"; //Rank gained sound
new g_Sound2[] = "fvox/bell.wav"; //Badges earned sound

//Sprite vars
new spritefile[21][36];
new sprite[21];

//Bf2 includes

//SQl vars
#if defined SQL
new Handle:g_SqlTuple
new Handle:g_SqlTuple2 
new g_Cache[512]
new bool:SQLenabled;
#else
//nVault.
new g_Vault;
#endif

#if defined SQL
	#include <sqlx>
	#include "bf2/sql.inl"
#else
	#include <nvault>
#endif


#include "bf2/effect.inl"
#include "bf2/const.inl"
#include "bf2/cmds.inl"
#include "bf2/events.inl"
#include "bf2/save.inl"
#include "bf2/forwards.inl"
#include "bf2/check.inl"
#include "bf2/badgepowers.inl"
#include "bf2/menu.inl"
#include "bf2/hud.inl"
#include "bf2/othermods.inl"
#include "bf2/csx.inl"

#if defined CSDM
	#include "bf2/bf2_csdm.inl"
#endif



public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR);

	//Register all the say commands

		//Public
	register_clcmd("say /ranks","show_rankhelp",0, "Shows The Rank Help");
	register_clcmd("say_team /ranks","show_rankhelp",0, "Shows The Rank Help");

	register_clcmd("say /badges1","show_badgehelp",0, "Shows The Badge Help");
	register_clcmd("say_team /badges1","show_badgehelp",0, "Shows The Badge Help");

	register_clcmd("say /badges2","show_badgehelp2",0, "Shows The Badge Help 2");
	register_clcmd("say_team /badges2","show_badgehelp2",0, "Shows The Badge Help 2");

	register_clcmd("say /badges3","show_badgehelp3",0, "Shows The Badge Help 3");
	register_clcmd("say_team /badges3","show_badgehelp3",0, "Shows The Badge Help 3");

	register_clcmd("say", "cmd_say", 0, "<target> ")
	register_clcmd("say_team", "cmd_say", 0, "<target> ")

	register_clcmd("say /who", "cmd_who", 0, "Display a list of player and their levels")
	register_clcmd("say_team /who", "cmd_who", 0, "Display a list of player and their levels")

	register_clcmd("say /hud", "ShowHUD", 0, "Shows the HUD")
	register_clcmd("say_team /hud", "ShowHUD", 0, "Shows the HUD")

	register_clcmd("say /help", "cmd_help", 0, "Displays the Help")
	register_clcmd("say_team /help", "cmd_help", 0, "Displays the Help")

	register_clcmd("say /bf2menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team /bf2menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say bf2menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team bf2menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say /bf2", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team /bf2", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say bf2", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team bf2", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say /menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team /menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team menu", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say /help", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team /help", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say help", "Bf2menu", 0, "Displays the Menu")
	register_clcmd("say_team help", "Bf2menu", 0, "Displays the Menu")

	register_clcmd("say /bf2helpmenu", "helpmenu", 0, "Displays the Help Menu")
	register_clcmd("say_team /bf2helpmenu", "helpmenu", 0, "Displays the Help Menu")

	register_clcmd("say /bf2statsmenu", "helpmenu", 0, "Displays the Stats Menu")
	register_clcmd("say_team /bf2statsmenu", "helpmenu", 0, "Displays the Stats Menu")

	register_clcmd("say /bf2adminmenu", "adminmenu", 0, "Displays the Admin Menu")
	register_clcmd("say_team /bf2adminmenu", "adminmenu", 0, "Displays the Admin Menu")

	register_clcmd("say /bf2stats", "show_stats", 0, "Shows your current weapon stats")
	register_clcmd("say_team /bf2stats", "show_stats", 0, "Shows your current weapon stats")

	register_clcmd("say /serverstats", "show_server_stats", 0, "Shows your current weapon stats")
	register_clcmd("say_team /serverstats", "show_server_stats", 0, "Shows your current weapon stats")

	register_clcmd("say /bf2save", "save_badges", 0, "Shows your current weapon stats")
	register_clcmd("say_team /bf2save", "save_badges", 0, "Shows your current weapon stats")

	register_clcmd("bf2_resetstats", "reset_stats", 0, "Resets all of your stats")

		//Admin
	register_clcmd("bf2_addbadge", "add_badge", ADMIN_LEVEL, "<player> <badge#> <level#>")
	register_clcmd("bf2_addkills", "add_kills", ADMIN_LEVEL, "<player> <kills#>")
	register_clcmd("bf2_resetserverstats", "reset_all_stats", ADMIN_LEVEL, "Erases all players stats")


	//Cvars

	//FCVAR_SERVER cvar for game monitor.
	register_cvar("bf2_version",VERSION,FCVAR_SERVER)

	g_bf2_active = register_cvar("bf2_active", "1")
	g_badges_active = register_cvar("bf2_badges", "1")
	g_free_awp = register_cvar("bf2_awp", "0")
	g_xp_multiplier = register_cvar("bf2_xpmultiplier", "0.1")
	g_icon_hold = register_cvar("bf2_icon_time","1.5")
	g_flag_kills = register_cvar("bf2_flag_kills","2")
	g_flag_round_kills = register_cvar("bf2_flag_round_kills", "0") 
	g_flag_match_kills = register_cvar("bf2_flag_match_kills", "0") 
	g_flag_min_players = register_cvar("bf2_flag_min_players", "1")
	g_help_url = register_cvar("bf2_help_url","")
	g_powers = register_cvar("bf2_badgepowers","1")
	g_hud_options = register_cvar("bf2_hud_options","abcd")
	g_prune_days = register_cvar("bf2_reset_days","21")
	
	//Message sending.
	
	gmsgStatusText = get_user_msgid("StatusText");
	gmsgScreenFade = get_user_msgid("ScreenFade");
	gmsgScreenShake = get_user_msgid("ScreenShake");
	gmsgScoreInfo = get_user_msgid("ScoreInfo");
	gmsgDeathMsg = get_user_msgid("DeathMsg");
	gmsgSayText = get_user_msgid("SayText");

	
	//Register events, logs and forwards to be captured
	
	register_event("ResetHUD", "event_hud_reset", "be")
	register_event("HLTV", "event_new_round", "a", "1=0", "2=0") //add freeztime start code
	register_event("CurWeapon", "event_curweapon", "be","1=1")

	register_logevent("end_freezetime", 2,"0=World triggered","1=Round_Start"); //freezetime end code
	register_logevent("Event_Round_End", 2, "1=Round_End");

	register_message(SVC_INTERMISSION,"event_intermission")
	
	register_event("StatusValue", "setTeam", "be", "1=1");
	register_event("StatusValue", "on_ShowStatus", "be", "1=2", "2!0");
	register_event("StatusValue", "on_HideStatus", "be", "1=1", "2=0");
	register_message(get_user_msgid("StatusValue"), "hook_StatusValue");
	g_status_sync = CreateHudSyncObj();
}