/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

void CAutomatic::Draw(CPlayer *player)
{
	player->nextattack[this->id] = gpGlobals->time + this->deploy_delay;
	player->pev->viewmodel=MAKE_STRING(this->viewmodel.c_str());
	player->pev->weaponmodel=MAKE_STRING(this->weaponmodel.c_str());
	MESSAGE_BEGIN(MSG_ONE, SVC_WEAPONANIM, NULL, player->edict);
	WRITE_BYTE(this->anim_draw);
	WRITE_BYTE(this->weapon_body);
	MESSAGE_END();
	player->pev->weaponanim=this->anim_draw;
	
}

void CAutomatic::Attack(CPlayer *player)
{
	//int block=0;
	// Execute the command...
	int ret = MF_ExecuteForward(func_attack,player->index);
	if (!(ret & 1)) // PLUGIN_HANDLED
	{
		player->nextattack[id]=gpGlobals->time + attack_delay;
		player->pev->weaponanim=anim_attack;
		MESSAGE_BEGIN(MSG_ONE,SVC_WEAPONANIM,NULL,player->edict);
		WRITE_BYTE(anim_attack);
		WRITE_BYTE(weapon_body);
		MESSAGE_END();
	}
}

