/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

CEntity	*g_entities[2048]; // such a crude method. :'(

void Think(edict_t *pEntity)
{
	if (!strncmp(STRING(pEntity->v.classname),"wmod",4))
	{
		CEntity *entity = ENT_PRIVATE(CEntity,pEntity);
		entity->Think();
		RETURN_META(MRES_SUPERCEDE);
	}
	RETURN_META(MRES_IGNORED);
}

void Touch(edict_t *pTouched,edict_t *pToucher)
{
	if (!pToucher || !pTouched) // Bail out
		RETURN_META(MRES_IGNORED);
	if (!strncmp(STRING(pTouched->v.classname),"wmod",4))
	{
		CEntity *entity = ENT_PRIVATE(CEntity,pTouched);
		if (!entity)
			RETURN_META(MRES_SUPERCEDE);
		entity->Touch(pToucher);
		RETURN_META(MRES_SUPERCEDE);
	}
	if (!strncmp(STRING(pToucher->v.classname),"wmod",4)) {
	    /*
		CEntity *entity = ENT_PRIVATE(CEntity,pToucher);
		if (!entity)
			RETURN_META(MRES_SUPERCEDE);
		if (entity->isGeneric()) {
		    CGenericEntity *e = ENT_PRIVATE(CGenericEntity,pTouched);
		    RETURN_META(MRES_SUPERCEDE);
		};*/    
		RETURN_META(MRES_SUPERCEDE);
	}			
	RETURN_META(MRES_IGNORED);
}

/* The engine is freeing this entity's private data, so free ours too! */
void OnFreeEntPrivateData(edict_t *pEntity)
{
	if (!strncmp(STRING(pEntity->v.classname),"wmod",4)) {
		if (ENT_PRIVATE(CEntity,pEntity)) {
			delete ENT_PRIVATE(CEntity,pEntity);
			g_entities[ENTINDEX(pEntity)]=NULL;
		}
		RETURN_META(MRES_SUPERCEDE);
	}
	RETURN_META(MRES_IGNORED);
}

void ObjectCollsionBox(edict_t *pEntity)
{
	if (!strncmp(STRING(pEntity->v.classname),"wmod",4)) {
		entvars_t *pev = &pEntity->v;
		CEntity *p = ENT_PRIVATE(CEntity,pEntity);
		pev->absmin = pev->origin + pev->mins;
		pev->absmax = pev->origin + pev->maxs;
		pev->absmin.x -= 1;
		pev->absmin.y -= 1;
		pev->absmin.z -= 1;
		pev->absmax.x += 1;
		pev->absmax.y += 1;
		pev->absmax.z += 1;
		RETURN_META(MRES_SUPERCEDE);
	}
	RETURN_META(MRES_IGNORED);
}
void CEntity::Remove()
{
	edict_t *pEntity = this->edict();
	delete ENT_PRIVATE(CEntity,pEntity);
	g_entities[ENTINDEX(pEntity)]=NULL;
	REMOVE_ENTITY(pEntity);
}
void CEntity::FrameAdvance()
{
	REAL flInterval = (gpGlobals->time - pev->animtime);
	if (flInterval <= 0.001)
	{
		pev->animtime = gpGlobals->time;
		return;
	}
	if (! pev->animtime)
		flInterval = 0.0;
	
	pev->frame += flInterval * 1.0 * pev->framerate;
	pev->animtime = gpGlobals->time;
	if (pev->frame < 0.0 || pev->frame >= 256.0) 
	{
		if (m_fSequenceLoops)
			pev->frame -= (int)(pev->frame / 256.0) * 256.0;
		else
			pev->frame = (pev->frame < 0.0) ? 0 : 255;
		m_fSequenceFinished = TRUE;	// just in case it wasn't caught in GetEvents
	}

}
BOOL CEntity::IsInWorld()
{
	// position 
	if (pev->origin.x >= 4096) return FALSE;
	if (pev->origin.y >= 4096) return FALSE;
	if (pev->origin.z >= 4096) return FALSE;
	if (pev->origin.x <= -4096) return FALSE;
	if (pev->origin.y <= -4096) return FALSE;
	if (pev->origin.z <= -4096) return FALSE;
	// speed
	if (pev->velocity.x >= 2000) return FALSE;
	if (pev->velocity.y >= 2000) return FALSE;
	if (pev->velocity.z >= 2000) return FALSE;
	if (pev->velocity.x <= -2000) return FALSE;
	if (pev->velocity.y <= -2000) return FALSE;
	if (pev->velocity.z <= -2000) return FALSE;

	return TRUE;
}
void CEntity::ClosestWall(TraceResult *tr, int up, int down)
{
	Vector		vecSpot;

	vecSpot = pev->origin + Vector ( 0 , 0 , up );

    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( 0, 0, -1 * down ),  ignore_monsters, edict(), tr);

	if (tr->flFraction == 1.0)
	{
		vecSpot = pev->origin + Vector ( 0 , 0 , -1 * up );
	    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( 0, 0, down ),  ignore_monsters, edict(), tr);
		if (tr->flFraction == 1.0)
		{
			vecSpot = pev->origin + Vector ( 0 , -1 * up , 0 );
		    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( 0, down, 0),  ignore_monsters, edict(), tr);
			if (tr->flFraction == 1.0)
			{
				vecSpot = pev->origin + Vector ( 0 , up , 0 );
			    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( 0, -1 * down, 0 ),  ignore_monsters, edict(), tr);
				if (tr->flFraction == 1.0)
				{
					vecSpot = pev->origin + Vector ( -1 * up, 0 , 0 );
				    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( down, 0, 0),  ignore_monsters, edict(), tr);
					if (tr->flFraction == 1.0)
					{
						vecSpot = pev->origin + Vector ( up , 0 , 0 );
					    UTIL_TraceLine ( vecSpot, vecSpot + Vector ( -1 * down, 0, 0),  ignore_monsters, edict(), tr);
					}
				}
			}
		}
	}

}
