/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CENTITY_H
#define CENTITY_H

#include "CGameBase.h"

class CEntity
{
public:
	CEntity() {
		m_pfnThink=NULL;
		m_pfnTouch=NULL;
		m_fSequenceLoops=0;
		m_fSequenceLoops=0;
	}
	virtual ~CEntity() { };
	entvars_t *pev;
	edict_t *m_pLink;
	void Remove();
    virtual int isGeneric() { return 0; };
	void (CEntity ::*m_pfnThink)(void);
	void (CEntity ::*m_pfnTouch)( edict_t *pOther );

	virtual void RoundReset() { Remove(); };

	virtual void Think(void) { 
		if (m_pfnThink) 
			(this->*m_pfnThink)(); 
	};
	virtual void Touch(edict_t *pOther) {
		if (m_pfnTouch)
			(this->*m_pfnTouch)(pOther); 
	};
	virtual void RoundRestart() { Remove(); };
	void FrameAdvance();
	void ClosestWall(TraceResult *tr, int up, int down);

	BOOL IsInWorld();
	edict_t *edict() { return ENT( pev ); };
	EOFFSET eoffset( ) { return OFFSET( pev ); };
	int	  entindex( ) { return ENTINDEX( edict() ); };

	virtual Vector Center( ) { return (pev->absmax + pev->absmin) * 0.5; }; // center point of entity
	virtual Vector EyePosition( ) { return pev->origin + pev->view_ofs; };			// position of eyes
	virtual Vector EarPosition( ) { return pev->origin + pev->view_ofs; };			// position of ears
	virtual Vector BodyTarget( const Vector &posSrc ) { return Center( ); };		// position to shoot at
	int	m_fSequenceFinished;
	int	m_fSequenceLoops;
	int m_Size;
	float	m_Maxs[3];
	float	m_Mins[3];
};

#define HURTABLE_HEALTH_BUFFER 10000
// An entity that's able to be harmed (and trigger death) semi-properly
class CHurtable : public CEntity
{
public:
	virtual ~CHurtable() { };
	virtual void Die() { Remove(); };
	void Think() {
		// This entity has fallen below our "health buffer"
		// Since we can't access TakeDamage, this is the only real sane way to do this, unfortunately.
		// call it's death function
		if ((int)pev->health <= HURTABLE_HEALTH_BUFFER) {
			Die();
		}
		else {
			if (m_pfnThink) 
				(this->*m_pfnThink)(); 
		}
	};

};

class CSnark : public CHurtable
{
public:
	CSnark() { };
	virtual ~CSnark() { };
	void Setup(edict_t *);
	void Spawn();
	void BounceTouch(edict_t *pOther);
	void HuntThink();
	void Die();
	void Look(int dist);
	BOOL FInViewCone(edict_t *pEntity);
	BOOL FVisible(edict_t *pEntity);
	edict_t *FindBestEnemy();


	String	m_SnarkModel;
	String	m_BlastSound;
	String	m_DieSound;
	String	m_BiteSound;
	String	m_HuntSound1;
	String	m_HuntSound2;
	String	m_HuntSound3;
	float	m_flDie;			// Time it'll die at
	float	m_flNextHunt; 
	float	m_flFieldOfView;
	edict_t	*m_hOwner;
	float	m_flNextBounceSoundTime;
	int		m_LaunchSequence;
	vec3_t	g_vecAttackDir;
	edict_t *m_hEnemy;
	edict_t	*m_Potentials[100];
	float	m_Damage;
	float	m_Life;
	float	m_Health;
	vec3_t	m_vecTarget;
	float	m_flNextHit;
	Vector	m_posPrev;
	float	m_flNextAttack;
	String	m_Classname;
	float	m_DamageBite;
	float	m_Speed;
	float	m_Mins[3];
	float	m_Maxs[3];

};


//
// Converts a entvars_t * to a class pointer
// It will allocate the class and entity if necessary
//
template <class T> 
T * MakeEnt( T *a )
{
	entvars_t *pev = (entvars_t *)a;
	if (pev == NULL)
		pev = VARS(CREATE_NAMED_ENTITY(MAKE_STRING("info_null")));

	a = (T *)g_entities[ENTINDEX(ENT(pev))];
	// Old entity private data, delete it!
	if (a)
		delete a;

	// !! DO NOT MDLL_SPAWN THIS !!
	// allocate private data 
	a = new T;
	a->pev = pev;
	a->pev->classname=MAKE_STRING("wmod_generic");
	g_entities[ENTINDEX(ENT(pev))]=a;
	return a;
}


#define CSetThink( a ) m_pfnThink = static_cast <void (CEntity::*)(void)> (a)
#define CSetTouch( a ) m_pfnTouch = static_cast <void (CEntity::*)(edict_t *)> (a)

#endif // CENTITY_H
