/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

CExplosion::CExplosion()
{
	m_Exp_Sprite=game->g_sModelIndexFireball;
	m_Exp_WaterSprite=game->g_sModelIndexWExplosion;
	m_Exp_Framerate=15;
	m_Exp_Flags=0;
	m_Exp_Scale=-1;
	m_Smo_Sprite=game->g_sModelIndexSmoke;
	m_Smo_FrameRate=12;
	m_Smo_Scale=-1;
	m_Damage_Radius=0;
	m_Damage=0;
	m_Flags= EXP_Explosion | EXP_Smoke | EXP_Decals;
	m_Spa_Num=-1;
	m_Intensity=125;
    m_BubbleIndex=game->g_sModelIndexBubbles;
	m_BubbleAmount=-1;
	m_BubbleSize=-1;
	m_BubbleHeight=-1;

}


void CExplosion::Explode()
{
	TraceResult tr;

	ClosestWall(&tr,8,40);
	float f[3];
	f[0]=pev->origin[0];
	f[1]=pev->origin[1];
	f[2]=pev->origin[2];

	PointContents = POINT_CONTENTS(f);
	if (m_Flags & EXP_Explosion)
	{
		MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, f);
			WRITE_BYTE(TE_EXPLOSION);
			WRITE_COORD(pev->origin[0]);
			WRITE_COORD(pev->origin[1]);
			WRITE_COORD(pev->origin[2]);
			if (PointContents  == CONTENTS_WATER)
				WRITE_SHORT(m_Exp_WaterSprite);
			else
				WRITE_SHORT(m_Exp_Sprite);
			if (m_Exp_Scale < 0) {
				WRITE_BYTE((int)((m_Intensity - 50) * .60));
			} else {
		    	WRITE_BYTE(m_Exp_Scale);
			}   
			WRITE_BYTE(m_Exp_Framerate);
			WRITE_BYTE(m_Exp_Flags);
		MESSAGE_END();
	}
	if (m_Spa_Num < 0) { // auto detect...
		m_Spa_Num = ((int)(m_Intensity / 100)) + 1;
	}    
    while (m_Spa_Num>0) {
		edict_t *p = CREATE_NAMED_ENTITY(MAKE_STRING("spark_shower"));
		SET_ORIGIN(p,f);
		MDLL_Spawn(p);
		p->v.nextthink=gpGlobals->time + 0.3;
		m_Spa_Num--;
	}		
	if (m_Flags & EXP_Decals)
	{
		if (RANDOM_LONG(0,1))
			UTIL_DecalTrace(&tr,m_Decal1.c_str("{scorch1"));
			
		else
			UTIL_DecalTrace(&tr,m_Decal2.c_str("{scorch2"));
	}
	if (m_Flags & EXP_Smoke)
	{
		CSetThink(&CExplosion::Smoke);
		pev->nextthink=gpGlobals->time+0.3;
	}
	else
		Remove();
}
void CExplosion::Smoke()
{
		if (PointContents == CONTENTS_WATER || m_Flags & EXP_AlwaysBubble)
		{
		    if (!(m_Flags & EXP_NeverBubble))
				UTIL_Bubbles(m_BubbleIndex, pev->origin, pev->origin, m_BubbleAmount < 0 ? (int)(m_Intensity * 0.80) : m_BubbleAmount, (float)m_BubbleHeight );
		}
		if (PointContents != CONTENTS_WATER || m_Flags & EXP_AlwaysSmoke)
		{
		    if (!(m_Flags & EXP_NeverSmoke)) {
				float f[3];
				f[0]=pev->origin[0];
				f[1]=pev->origin[1];
				f[2]=pev->origin[2];
				MESSAGE_BEGIN(MSG_PVS, SVC_TEMPENTITY, f);
					WRITE_BYTE(TE_SMOKE);
					WRITE_COORD(pev->origin[0]);
					WRITE_COORD(pev->origin[1]);
					WRITE_COORD(pev->origin[2]);
					WRITE_SHORT(m_Smo_Sprite);
					if (m_Smo_Scale < 0) {
						WRITE_BYTE((int)((m_Intensity - 50) * 0.80)); // scale * 10
					} else {
					    WRITE_BYTE(m_Smo_Scale);
					}    
					WRITE_BYTE(m_Smo_FrameRate); // framerate
				MESSAGE_END();
			}
		}
		Remove();
}
