/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CEXPLOSION_H
#define CEXPLOSION_H

enum CExplosionFlags {
	EXP_Decals				=	(1<<0),
	EXP_Exp_Particles		=	(1<<1),
	EXP_Exp_Lights			=	(1<<2),
	EXP_Exp_Sound			=	(1<<3),
	EXP_Exp_Sprite			=	(1<<4),
	EXP_Smoke				=	(1<<5),
	EXP_Explosion			=	(1<<6),
	EXP_AlwaysSmoke			=	(1<<7),
	EXP_NeverSmoke			=	(1<<8),
	EXP_AlwaysBubble		=	(1<<9),
	EXP_NeverBubble			=	(1<<10)
};

class CExplosion : public CEntity
{
public:
	CExplosion();
	void Explode(void);
	void Smoke(void);

	int		PointContents;
	int		m_Intensity;

	// TE_EXPLOSION config
	short	m_Exp_Sprite;
	short	m_Exp_WaterSprite;
	int		m_Exp_Scale;
	int		m_Exp_Framerate;
	int		m_Exp_Flags;

	// TE_SMOKE config
	short	m_Smo_Sprite;
	int		m_Smo_Scale; // (BYTE)m_spriteScale ); // scale * 10
	int		m_Smo_FrameRate; // 12  ); // framerate

	// Sparks?
	int		m_Spa_Num;
	
	// Damage?
	REAL		m_Damage_Radius;  // Radius for damage
	REAL		m_Damage;		  // how much damage we do at epicenter

	// miscellaneous flags
	int		m_Flags;
	
	// decals...
	String	m_Decal1;
	String	m_Decal2;
	
	// bubbles
	int m_BubbleIndex;
	int m_BubbleAmount;
	int m_BubbleSize;
	int m_BubbleHeight;
};

#endif // CEXPLOSION_H

