/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"
void CGameBase::RoundRestart()
{
	// Tell all "wmod_generics"'s (projectiles, snarks, explosions) that the rounds restartings
	edict_t *e = NULL;
	while ((e = UTIL_FindEntityByClassname(e,"wmod_generic"))!=NULL)
	{
		CEntity *c = ENT_PRIVATE(CEntity,e);
		c->RoundReset();
	}
	int i=1;
	// stop hooking!
	while (i<=gpGlobals->maxClients)
	{
		CPlayer *p=GET_PLAYER_I(i);
		if (p)
		{
			if (p->curweapon)
			{
				if (p->curweapon->isStandardWeapon!=TRUE)
				{
					p->pev->viewmodel=MAKE_STRING(p->lastNormalWeaponV);
					p->pev->weaponmodel=MAKE_STRING(p->lastNormalWeaponP);
					p->curweapon=GET_WEAPON(p->lastNormalWeapon);
				}
				else
					p->curweapon=GET_WEAPON(0);
			}
			else
				p->curweapon=GET_WEAPON(0);
		}
		i++;
	}
}
void CGameBase::Log()
{
	printf("Log param(%d):",LogData.size());
	for (int i=1;i<=LogData.size();i++)
		printf(" `%s`",LogData.get(i));
	printf("\n");
}
int CGameBase::CanBeDamaged(edict_t *victim,edict_t*attacker)
{
	//   invincible						god mode					  dead already
	if (victim->v.takedamage == 0 || victim->v.flags & FL_GODMODE || victim->v.deadflag > 0 || victim->v.health <= 0.0)
		return 0;
	// same player
	if (victim == attacker)
		return 1;
	if (victim->v.team == 0)
		return 1;
	// This is done after the check for entvar.takedamage, so dont bother
	// Different team
	if (victim->v.team != attacker->v.team)
		return 1;
	// Same team, but friendlyfire is on
	if (mp_friendlyfire &&					// mp_friendlyfire cvar pointer exists
		mp_friendlyfire->value > 0.0 &&		// it's greater than 0
		victim->v.team == attacker->v.team)	// they're on the same team
		return 1;
	return 0;
}
void CGameBase::TakeDamage(edict_t *victim, edict_t *attacker, String *inflictor, REAL damage)
{
	// If the victim cannot take damage, stop
	if (!victim->v.takedamage)
		return;
	if (!CanBeDamaged(victim,attacker)) // Check game rules to make sure this ent can be damaged
		return;
	// If they're a player, call the PlayerTakeDamage routine
	if (ENTINDEX(victim) <= gpGlobals->maxClients && ENTINDEX(victim) >= 1)
		PlayerTakeDamage(GET_PLAYER_E(victim),attacker,inflictor,damage);

	else
	{
		// Normal entity armor values are not accounted for.
		victim->v.health -= damage;
		if (victim->v.health <= 0.0)
		{
			// Reset it to 0 just in case
			victim->v.health = 0.0;
			// Force it to think
			gpGamedllFuncs->dllapi_table->pfnThink(victim);
			// If it's still around, force it to be used (func_breakables)
			if (!FNullEnt(victim))
			{
				gpGamedllFuncs->dllapi_table->pfnUse(victim,victim);
			}
		}
	}
};


void CGameBase::PlayerTakeDamage(CPlayer *player, edict_t *attacker, String *inflictor, REAL damage)
{
	// Truncate any names of weapons here 
	// (so it appears like: player killed victim with awp
	//  instead of player killed victim with weapon_awp)
	inflictor->truncate("weapon_");
	inflictor->truncate("func_");
	inflictor->truncate("monster_");
	if (player->pev->armorvalue > 0) // player has armor
	{
		REAL fl_Absorbable = (damage * m_ArmorAbsorb); // how much of the damage is being factored into the armor?
		REAL fl_ArmorLoss = (fl_Absorbable / m_ArmorValue); // how much armor is actually lost
		if (fl_ArmorLoss > player->pev->armorvalue) // the damage will overcome the armor
		{
			REAL fl_Percent = player->pev->armorvalue / fl_ArmorLoss; // Get percentage of armor we actually have...
			fl_Absorbable *= fl_Percent; // Multiply this by the percentage of armor we actually have
			player->pev->armorvalue=0.0;
			fl_ArmorLoss = 0;
		}
		damage -= fl_Absorbable; // subtract the absorbed damage
		player->pev->health -= damage;
		player->pev->armorvalue -= fl_ArmorLoss;
	}
	else
		player->pev->health -= damage;
	if (player->pev->health < 1) // they have 0 or a fraction of a health point left - kill them
	{
		float vFrags = player->edict->v.frags;
		if (attacker != player->edict)
			attacker->v.frags += 1.0;

		msg.result = alertRes = MRES_SUPERCEDE; // block the death from logging
		gpGamedllFuncs->dllapi_table->pfnClientKill(player->edict); // make them suicide

		if (attacker != player->edict)
			player->edict->v.frags = vFrags;

		if (ENTINDEX(attacker) >0 && ENTINDEX(attacker) <= gpGlobals->maxClients)
		{
			sendDeathMsg(GET_PLAYER_E(attacker),player,inflictor->c_str());
			logDeath(GET_PLAYER_E(attacker),player,inflictor->c_str());
		}
		else
		{
			sendDeathMsg(player,player,inflictor->c_str());
			logDeath(player,player,inflictor->c_str());
		}
		msg.result = alertRes = MRES_IGNORED; // unblock these events
	}
}

void CGameBase::sendDeathMsg(CPlayer *attacker, CPlayer *victim, const char *weaponName)
{
	/* Format:
	 * Byte: Attacker Index
	 * Byte: Victim Index
	 * String: Weapon description
	 */
	// Verify DeathMsg is set
	if (gmsgDeathMsg)
	{
		// Send death message
		MESSAGE_BEGIN(MSG_ALL,gmsgDeathMsg);
			WRITE_BYTE(attacker->index);
			WRITE_BYTE(victim->index);
			// If weaponName is provided, use it. Otherwise, use what the current weapon is called.
			if (weaponName != NULL)
			{
				WRITE_STRING(weaponName);
			}
			else
			{
				WRITE_STRING(attacker->curweapon->name.c_str());
			}
		MESSAGE_END();
	}
}

void CGameBase::logDeath(CPlayer *attacker, CPlayer *victim, const char *weaponName)
{
	// This player killed himself...
	if (attacker==victim)
	{
		UTIL_LogPrintf("\"%s<%d><%s><%s>\" committed suicide with \"%s\"\n",
			attacker->getName(),attacker->getID(),attacker->getAuth(),attacker->getTeam(),
			weaponName);
	}
	else
	{
		UTIL_LogPrintf("\"%s<%d><%s><%s>\" killed \"%s<%d><%s><%s>\" with \"%s\"\n",
			attacker->getName(),attacker->getID(),attacker->getAuth(),attacker->getTeam(),
			victim->getName(),victim->getID(),victim->getAuth(),victim->getTeam(),
			weaponName);
	}
};
// mostly ripped from HLSDK :D
void CGameBase::RadialDamage(edict_t *ent, String *inflictor, REAL flDamage, REAL flRadius )
{
	edict_t *pEntity = NULL;
	TraceResult	tr;
	float		flAdjustedDamage, falloff;
	Vector		vecSpot;
	Vector		vecSrc=ent->v.origin;
	edict_t		*owner=ent;
	if (ent->v.owner)
		owner=ent->v.owner;

	if ( flRadius )
		falloff = flDamage / flRadius;
	else
		falloff = 1.0;

	int bInWater = (UTIL_PointContents ( vecSrc ) == CONTENTS_WATER);

	vecSrc.z += 1;// in case grenade is lying on the ground

	while ((pEntity = UTIL_FindEntityInSphere(pEntity, vecSrc, flRadius )) != NULL)
	{
		if ( pEntity->v.takedamage != DAMAGE_NO )
		{
			if (!CanBeDamaged(pEntity,owner))
				continue;
			if (bInWater && pEntity->v.waterlevel == 0)
				continue;
			if (!bInWater && pEntity->v.waterlevel == 3)
				continue;

			vecSpot = (pEntity->v.absmax + pEntity->v.absmin) * 0.5;
			
			UTIL_TraceLine ( vecSrc, vecSpot, dont_ignore_monsters, ent, &tr );

			if ( tr.flFraction == 1.0 || tr.pHit == pEntity )
			{
				if (tr.fStartSolid)
				{
					tr.vecEndPos = vecSrc;
					tr.flFraction = 0.0;
				}
				
				flAdjustedDamage = ( vecSrc - tr.vecEndPos ).Length() * falloff;
				flAdjustedDamage = flDamage - flAdjustedDamage;
			
				if ( flAdjustedDamage < 0 )
				{
					flAdjustedDamage = 0;
				}
				TakeDamage(pEntity, owner, inflictor, flAdjustedDamage);
			}
		}
	}

};

void CGameBase::initialize()
{
	/* Initialize the default needed message IDs here.
	 * DeathMsg: Send a death event
	 * CurWeapon: Send info about a player's weapons
	 * WeaponList: Used to manage the hud display of weapons
	 * (This is called in ServerActivate_Post)
	 */
	gmsgDeathMsg = GET_USER_MSG_ID(&Plugin_info,"DeathMsg",NULL);
	gmsgCurWeapon = GET_USER_MSG_ID(&Plugin_info,"CurWeapon",NULL);
	gmsgWeaponList = GET_USER_MSG_ID(&Plugin_info,"WeaponList",NULL);
	gmsgTeamInfo = GET_USER_MSG_ID(&Plugin_info,"TeamInfo",NULL);
	gmsgBattery = GET_USER_MSG_ID(&Plugin_info,"Battery",NULL);
	/* Now initialize any game-specific cvars
	 */
	mp_friendlyfire = CVAR_GET_POINTER("mp_friendlyfire");
	/* Initialize gameplay variables
	 */
	m_ArmorAbsorb=0.5; // 50% absorb for armor (takedamage)
	m_ArmorValue=2.0;  // each armor point accounts for 2 HP

}
int CGameBase::isHook(int msgId)
{
	msgHook=FALSE;
	msgCmd=NULL;
	if (msgId == gmsgCurWeapon)
		MsgCmd(&CGameBase::execCurWeapon);
	/*
	if (msgId == gmsgWeaponList)
		msgCmd=NULL;//MsgCmd(&execWeaponList);
		*/
	if (msgId == gmsgDeathMsg)
		MsgCmd(&CGameBase::execDeathMsg);
	if (msgId == gmsgTeamInfo)
		MsgCmd(&CGameBase::execTeamInfo);
	return msgHook;
}
void CGameBase::execTeamInfo(CMessageInfo *m) 
{
	int id=m->geti(1);
	const char *name=m->gets(2);
	// Note the player's team down, so incase we need to log a death from them, we have the information handy.
	if (id < 1 || id > gpGlobals->maxClients)
		return;
	CPlayer *player = GET_PLAYER_I(id);
	strncpy(player->team,name,31);
}
void CGameBase::execCurWeapon(CMessageInfo *m)
 {
	int active=m->geti(1);
	int id=m->geti(2);
	int ammo=m->geti(3);
	// Verify it's sent to a client
	if (msg.msg_ed == NULL || ENTINDEX(msg.msg_ed) < 1 || ENTINDEX(msg.msg_ed) > gpGlobals->maxClients)
		return;
	CPlayer *player = GET_PLAYER_E(msg.msg_ed);
	// If all parameters are zero, then the player has no active weapon
	if (active == 0 && id == 0 && ammo == 0)
	{
		player->CurWeapon(0);
		return;
	}
	// Don't worry about inactive weapons...
	if (active)
		player->CurWeapon(id);
}
void CGameBase::execDeathMsg(CMessageInfo *m)
{
	//int killer=m->geti(1);
	int victim=m->geti(2);
	//const char *weapon=m->gets(3);;
	if (victim < 1 || victim > gpGlobals->maxClients)
		return;
	CPlayer *player = GET_PLAYER_I(victim);
	player->Die();
}
void CGameBase::Precache()
{
	g_sModelIndexFireball = PRECACHE_MODEL ("sprites/zerogxplode.spr");
	g_sModelIndexWExplosion = PRECACHE_MODEL ("sprites/WXplo1.spr");
	g_sModelIndexSmoke = PRECACHE_MODEL ("sprites/steam1.spr");
	g_sModelIndexBubbles = PRECACHE_MODEL ("sprites/bubble.spr");
	g_sModelIndexBloodSpray = PRECACHE_MODEL ("sprites/bloodspray.spr"); // initial blood
	g_sModelIndexBloodDrop = PRECACHE_MODEL ("sprites/blood.spr"); // splattered blood 
}
