/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CGAMEBASE_H
#define CGAMEBASE_H

#include "CMessageInfo.h" 
#include "String.h"

enum GameTypes {
	GAME_UNKNOWN = 0,
	GAME_CSTRIKE,
	GAME_DOD,
	GAME_TFC,
	GAME_NS,
	GAME_VALVE,
	GAME_DMC,
	GAME_TS // Untested, but planned. :)
};


/* CGameBase is the class a "HLSDK-Following" game will use for it's event referencing.
 * Other game classes also derive off of this.
 */
class CGameBase
{
public:
	virtual void initialize(void);
	virtual void RadialDamage(edict_t *ent, String *inflictor, REAL flDamage, REAL flRadius );
	virtual void PlayerTakeDamage(CPlayer *player, edict_t *attacker, String *inflictor, REAL damage);
	int CanBeDamaged(edict_t *victim, edict_t *attacker);
	virtual void TakeDamage(edict_t *victim, edict_t *attacker, String *inflictor, REAL damage);
	virtual int isHook(int msgId);
	virtual void logDeath(CPlayer *attacker, CPlayer *victim, const char *weaponName=NULL);
	virtual void sendDeathMsg(CPlayer *attacker, CPlayer *victim, const char *weaponName=NULL);
	virtual void execTeamInfo(CMessageInfo *m);
	virtual void execCurWeapon(CMessageInfo *m);
	virtual void execDeathMsg(CMessageInfo *m);
	virtual void Precache();
	virtual void Log();

	virtual void RoundRestart();

	// msgCmd
	void (CGameBase::*msgCmd)(CMessageInfo*);
	void executeMessage(CMessageInfo*m) {
		if (msgCmd)
			(this->*msgCmd)(m);
	}
	int msgHook;
	// message IDs
	cvar_t *mp_friendlyfire;
	int gmsgDeathMsg;
	int gmsgCurWeapon;
	int gmsgWeaponList;
	int gmsgTeamInfo;
	int gmsgBattery;
	float m_ArmorAbsorb;
	float m_ArmorValue;
	short	g_sModelIndexFireball;
	short	g_sModelIndexWExplosion;
	short	g_sModelIndexSmoke;
	short	g_sModelIndexBubbles;
	short	g_sModelIndexBloodDrop;// holds the sprite index for the initial blood
	short	g_sModelIndexBloodSpray;// holds the sprite index for splattered blood
	GameTypes	type;

};

#define MsgCmd(x) { msgCmd = static_cast <void (CGameBase::*)(CMessageInfo*)> (x); msgHook = TRUE; };


class CGameHLDM : public CGameBase
{
};

class CGameNS : public CGameBase
{
public:
	void Log() {
		if (LogData.size() == 1) {
			if (!strcmp(LogData.get(1),"Game reset complete."))
				RoundRestart();
		}
	};	
};

class CGameDMC : public CGameBase
{
	int CanBeDamaged(edict_t *victim, edict_t *attacker) {
		if (victim->v.takedamage)
			return 1;
		return 0;

	};
	void logDeath(CPlayer *attacker, CPlayer *victim, const char *weaponName=0) {
	// This player killed himself...
		if (attacker==victim)
		{
			UTIL_LogPrintf("\"%s<%d><%s><%s>\" committed suicide with \"%s\"\n",
				attacker->getName(),attacker->getID(),attacker->getAuth(),/* no teams in hldm/dmc use userid instead */attacker->getID(),
				weaponName);
		}
		else
		{
			UTIL_LogPrintf("\"%s<%d><%s><%s>\" killed \"%s<%d><%s><%s>\" with \"%s\"\n",
				attacker->getName(),attacker->getID(),attacker->getAuth(),attacker->getID(),
				victim->getName(),victim->getID(),victim->getAuth(),victim->getID(),
				weaponName);
		}
	};

};

class CGameCS : public CGameBase
{
public:
	void Log();
	void sendDeathMsg(CPlayer *attacker, CPlayer *victim, const char *weaponName=NULL);

};
class CGameDoD : public CGameBase
{
public:
	void Log();
	void logDeath(CPlayer *attacker, CPlayer *victim, const char *weaponName=0);
};


#endif // CGAMEBASE_H
