/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

void CGameDoD::Log()
{
	if (LogData.size() == 6) // "Team" "scored" "X" "with" "X" "players"
	{
		if (!strcmp(LogData.get(1),"Axis") && !strcmp(LogData.get(2),"scored") && !strcmp(LogData.get(4),"with") && !strcmp(LogData.get(6),"players"))
		{
			RoundRestart();
		}
	}
}
void CGameDoD::logDeath(CPlayer *attacker, CPlayer *victim,const char *weaponName)
{
	// This player killed himself...
	if (attacker==victim)
	{
		UTIL_LogPrintf("\"%s<%d><%s><%s>\" committed suicide with \"%s\"\n",
			attacker->getName(),attacker->getID(),attacker->getAuth(),attacker->pev->team == 1 ? "Allies" : "Axis",
			weaponName);
	}
	else
	{
		UTIL_LogPrintf("\"%s<%d><%s><%s>\" killed \"%s<%d><%s><%s>\" with \"%s\"\n",
			attacker->getName(),attacker->getID(),attacker->getAuth(),attacker->pev->team == 1 ? "Allies" : "Axis",
			victim->getName(),victim->getID(),victim->getAuth(),victim->pev->team == 1 ? "Allies" : "Axis",
			weaponName);
	}
};
