/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CMESSAGEINFO_H
#define CMESSAGEINFO_H

enum MSGINFOTYPES
{
	MSG_Ivalid=0,
	MSG_Byte,
	MSG_Char,
	MSG_Short,
	MSG_Long,
	MSG_Angle,
	MSG_Coord,
	MSG_String,
	MSG_Entity
};

struct MESSAGEINFO
{
	int type;
	void *info;
	MESSAGEINFO *next;
	MESSAGEINFO *prev;
};
class CMessageInfo
{
private:
	void add(MESSAGEINFO *a) {
		if (last == NULL) {
			last=a;
			first=a;
			last->next=NULL;
			a->prev=NULL;
		} else {
			// link it.
			last->next=a;
			a->next=NULL;
			a->prev=last;
			last=a;
		}
	};

public:
CMessageInfo() {
		first=NULL;
		last=NULL;
		result=MRES_IGNORED;
		count=0;
	};
	~CMessageInfo() { clear();  };
	void clear() {
		// Free memory for all linked messageinfos
		MESSAGEINFO *a = first;
		MESSAGEINFO *b;
		hooked=FALSE;
		while (a) {
			b = a->next;
			if (a->info != NULL) {
				if (a->type == MSG_Byte || 
				a->type == MSG_Char ||
				a->type == MSG_Short ||
				a->type == MSG_Long ||
				a->type == MSG_Entity) 
					delete (int*)a->info;
				else if (a->type == MSG_Coord ||
				a->type == MSG_Angle)
					delete (float*)a->info;
				else if (a->type == MSG_String)
					delete [] (char*)a->info;
			}
			delete a;
			if (b) {
				b->prev=NULL;
				a=b;
			} else {
			    a=NULL;
			}    
			last=NULL;
			first=NULL;
		}		
	};
	int geti(int num) {
		link=first;
		num--;
		while (num>0) {
			if (link->next)
				link=link->next;
			else
				break;
			num--;
		}
		return *((int*)link->info);
	};
	float getf(int num) {
		link=first;
		num--;
		while (num>0) {
			if (link->next)
				link=link->next;
			else
				break;
			num--;
		}
		return *((float*)link->info);
	};
	const char *gets(int num) {
		link=first;
		num--;
		while (num>0) {
			if (link->next)
				link=link->next;
			else
				break;
			num--;
		}
		return ((const char*)link->info);
	};
	void add(int i, int type) {
		MESSAGEINFO* a = new MESSAGEINFO;
		if (a) {
			a->info = new int;
			*((int *)a->info) = i;
			a->type=type;
			// Add it to the linked list
			add(a);
		}
	};
	void add(float f, int type) {
		MESSAGEINFO* a = new MESSAGEINFO;
		if (a) {
			a->info = new float;
			*((float *)a->info) = f;
			a->type=type;
			// Add it to the linked list
			add(a);
		}
	};
	void add(const char *s, int type) {
		MESSAGEINFO* a = new MESSAGEINFO;
		if (a) {
			a->info = new char[512];
			strncpy(((char*)a->info),s,511);
			a->type=type;
			// Add it to the linked list
			add(a);
		}
	};
	int count;
	MESSAGEINFO *first;
	MESSAGEINFO *last;
	MESSAGEINFO *link;

	META_RES result;
	int hooked;
	int msg_type;
	int msg_dest;
	float *msg_loc;
	edict_t *msg_ed;

};

#endif // CMESSAGEINFO_H

