/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

// Return TRUE to block the attack, FALSE otherwise.
BOOL CPlayer::Attack2()
{
	// Check if the player is currently holding a standard weapon.
	f_Attack2This=FALSE;
	if (curweapon == NULL)
		return FALSE;
	if (curweapon->isStandardWeapon==FALSE)
	{
		// No.  Block the attack keys.
		f_Attack2This=TRUE;

		// Check rate of fire time.  If this weapon can be fired, then set it here.
		if (nextattack[curweapon->id] <= gpGlobals->time)
		{
			nextattack[curweapon->id] = gpGlobals->time + curweapon->attack_delay;
			curweapon->Attack2(this);
			f_Attack2Last=f_Attack2This;
			return TRUE;
		}
		f_Attack2Last=f_Attack2This;
		return TRUE;
	}
	f_Attack2Last=f_Attack2This;
	return FALSE;
}
// Return TRUE to block the attack, FALSE otherwise.
BOOL CPlayer::Attack()
{
	if (pev->deadflag > 0)
		return TRUE;
	f_AttackLast=f_AttackThis;
	// Check if the player is currently holding a standard weapon.
	if (curweapon == NULL)
	{
		f_AttackThis=FALSE;
		f_AttackLast=FALSE;
		return FALSE;
	}
	if (curweapon->isStandardWeapon==FALSE)
	{
		// No.  Block the attack keys.
		f_AttackThis=TRUE;

		// Check rate of fire time.  If this weapon can be fired, then set it here.
		if (nextattack[curweapon->id] <= gpGlobals->time)
		{
			nextattack[curweapon->id] = gpGlobals->time + curweapon->attack_delay;
			curweapon->Attack(this);
			return TRUE;
		}
		return TRUE;
	}
	return FALSE;
}

void CPlayer::Draw(int weaponid)
{
	if (edict->v.deadflag > 0)
		return;
	lastinv = curweapon;
	curweapon = GET_WEAPON(weaponid);
	// Fix for stuff that causes hooked weapon to stop hooking
	if (lastinv)
	{
		if (lastinv->isStandardWeapon)
		{
			lastNormalWeapon=lastinv->id;
			strncpy(lastNormalWeaponV,STRING(pev->viewmodel),127);
			strncpy(lastNormalWeaponP,STRING(pev->weaponmodel),127);
		}
	}
	if (curweapon != NULL)
	{
		if (curweapon->isStandardWeapon)
		{
			if (curweapon->id == this->lastNormalWeapon)
			{
				pev->viewmodel=MAKE_STRING(this->lastNormalWeaponV);
				pev->weaponmodel=MAKE_STRING(this->lastNormalWeaponP);
			}
		}
		curweapon->Draw(this);
	}
}
void CPlayer::Die()
{
	CurWeapon(0);
}
void CPlayer::PutInServer(edict_t *pEntity)
{
	connected=true;
	edict=pEntity;
	index=ENTINDEX(pEntity);
	pev=&pEntity->v;
	curweapon=NULL;
	oldpev=pEntity->v;
//	Clear();
}
void CPlayer::Disconnect()
{
	connected=false;
	strncpy(team,"",31);
}
void CPlayer::PreThink()
{
	if (f_AttackThis && pev->button & IN_ATTACK)
		pev->button &= ~IN_ATTACK;
	f_AttackLast = f_AttackThis;
	oldpev=edict->v;
	if (curweapon &&								// Current weapon pointer exists
		curweapon->fNextThink[index] &&					// Is thinking...
		!curweapon->isStandardWeapon &&						// Not a standard weapon
		gpGlobals->time >= curweapon->fNextThink[index])	// Should think now
	{
		curweapon->fNextThink[index]=0.0;					// Reset
		curweapon->Think(this);							// Think!
	}
}
void CPlayer::CurWeapon(int weaponid)
{
	if (curweapon)
	{
		// We're switching to a new weapon.  Stop all hooks
		curweapon = GET_WEAPON(weaponid);
	}
	else
		curweapon=NULL;
}
