/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CPLAYER_H
#define CPLAYER_H

class CWeapon; 
class CPlayer
{
public:

	CPlayer() {
		edict=NULL;
		pev=NULL;
		curweapon=NULL;
		lastinv=NULL;
	};

	// General information
	const char *getAuth() { 
		if (edict) return (*g_engfuncs.pfnGetPlayerAuthId)(edict);
		return NULL;
	};
	const char *getTeam() { return (const char*)&team; };
	const char *getName() { return MF_GetPlayerName(index); };
	int getID() { return (*g_engfuncs.pfnGetPlayerUserId)(edict); };
	int isDead() { return pev->deadflag > 0 ? TRUE : FALSE; };

	BOOL Attack();
	BOOL Attack2();
	void PutInServer(edict_t *pEntity);
	void Disconnect();
	void PreThink();
	void Die();
	void Draw(int weaponid);
	void CurWeapon(int weaponid);
	edict_t *edict;
	entvars_t *pev;

	entvars_t oldpev;
	int index;

	CWeapon	*curweapon;
	CWeapon	*lastinv;

	BOOL f_AttackLast;		// Did they attack last frame? (Needed since oldbuttons will return incorrect results)
	BOOL f_AttackThis;		// Are they attacking this frame? (To block it at all required places)  Automatically cleared every PostThink_Post, set during CmdStart
	BOOL f_Attack2Last;		// Did they attack last frame? (Needed since oldbuttons will return incorrect results)
	BOOL f_Attack2This;		// Are they attacking this frame? (To block it at all required places)  Automatically cleared every PostThink_Post, set during CmdStart
	char team[32];
	bool connected;
	int weaponid;
	float nextattack[MODULE_MAX_WEAPONS + 32];
	int weaponstate[MODULE_MAX_WEAPONS + 32];
	int hasweapon[MODULE_MAX_WEAPONS + 32];
	int	ammo[MODULE_MAX_WEAPONS+32];
	int resammo[MODULE_MAX_WEAPONS+32];

	char lastNormalWeaponV[128];
	char lastNormalWeaponP[128];
	int lastNormalWeapon;

};
#endif
