/* This file is part of AMXX Weapons Module
 * (c) 2004 Steve Dudenhoeffer
 * Licensed under the GNU General Public License version 2.
 * See: http://www.gnu.org/licenses/gpl.txt
 */

#include "weaponmod.h"




void CProjectile::ProjThink(void) {
	// Explode after so long?
	if (pev->dmgtime > 0 &&
		pev->dmgtime <= gpGlobals->time)
	{

		Explode(NULL /* Fuse explosion*/);
		return;
	}
}

void CProjectile::ExpTouch(edict_t *pOther) {
	if (!pOther) // Bail out
		return;
	if (pev->owner == pOther)
		return;
	// Never explode on a non-solid ent
	if (pOther->v.solid == SOLID_NOT || pOther->v.solid == SOLID_TRIGGER)
		return;
	// Contact grenades?
	if (miscFlags & PROJ_Contact) {
		TraceResult tr;
		Vector		vecSpot;// trace starts here!


		vecSpot = pev->origin - pev->velocity.Normalize() * 32;
		UTIL_TraceLine( vecSpot, vecSpot + pev->velocity.Normalize() * 64, ignore_monsters, ENT(pev), &tr );
		if ( tr.flFraction != 1.0 )
		{
			pev->origin = tr.vecEndPos + (tr.vecPlaneNormal * (75 - 24) * 0.6);
		}

		Explode(pOther);
		return;
	}
	// Bouncing grenade projectile
	else if (!(miscFlags & PROJ_Fly)) {
		// FL_ONGROUND doesn't matter here, solidity is already checked
		if (pev->velocity.Length() > m_HighSpeedThreshold)
			pev->velocity = pev->velocity * m_HighSpeedGroundFriction;
		else
			pev->velocity = pev->velocity * m_LowSpeedGroundFriction;

		if (pev->waterlevel > 0)
			pev->velocity = pev->velocity * m_WaterFrictionFactor;
		if (miscFlags & PROJ_Spin)
		{
			//VEC_TO_ANGLES(pev->velocity,pev->avelocity);
			pev->avelocity=pev->velocity;
		}
	}
	return;
};

void CProjectile::ProjSpawn(void) {
	// Set the origin...
	float origin[3];
	if (!pev->owner)
		origin[0] = origin[1] = origin[2] = 0.0;
	else
	{
		origin[0]=pev->owner->v.origin[0] + pev->owner->v.view_ofs[0];
		origin[1]=pev->owner->v.origin[1] + pev->owner->v.view_ofs[1];
		origin[2]=pev->owner->v.origin[2] + pev->owner->v.view_ofs[2];
	}
	SET_ORIGIN(edict(),origin);


	// and size
	if (m_Size)
	{
		float mins[3];
		float maxs[3];
		mins[0]=-1 * (float)m_Size;
		mins[1]=-1 * (float)m_Size;
		mins[2]=-1 * (float)m_Size;
		maxs[0]=(float)m_Size;
		maxs[1]=(float)m_Size;
		maxs[2]=(float)m_Size;
		SET_SIZE(edict(),mins,maxs);
		float x = (float)m_Size;
		float n = -1 * (float)m_Size;
		pev->mins[0]=n;
		pev->mins[1]=n;
		pev->mins[2]=n;
		pev->maxs[0]=x;
		pev->maxs[1]=x;
		pev->maxs[2]=x;
		pev->absmin = pev->origin + pev->mins;
		pev->absmax = pev->origin + pev->maxs;
		pev->absmin.x -= 1;
		pev->absmin.y -= 1;
		pev->absmin.z -= 1;
		pev->absmax.x += 1;
		pev->absmax.y += 1;
		pev->absmax.z += 1;
	}
	if (miscFlags & PROJ_Solid) {
		pev->solid=SOLID_BBOX;
	}
	else {
		pev->solid=SOLID_TRIGGER;
	}
	if (miscFlags & PROJ_Fly) {
		pev->movetype = MOVETYPE_FLY;
	}
	else {
		pev->movetype = MOVETYPE_BOUNCE;
	}
	if (miscFlags & PROJ_Glow) {
		pev->effects |= EF_LIGHT;
	}
	if (m_Fuse == 0.0) {
		m_Fuse=10.0;
	}
	printf("m_Model.set()==%d\n",m_Model.set());
	if (m_Model.set()) SET_MODEL(edict(),m_Model.c_str());

	if (miscFlags & PROJ_Trail) {
		MESSAGE_BEGIN(MSG_ALL,SVC_TEMPENTITY);
			WRITE_BYTE(TE_BEAMFOLLOW);
			WRITE_SHORT(ENTINDEX(pev->pContainingEntity));
			WRITE_SHORT(m_TrailIndex);
			WRITE_BYTE(m_TrailLife);
			WRITE_BYTE(m_TrailWidth);
			WRITE_BYTE((int)m_TrailColors[0]);
			WRITE_BYTE((int)m_TrailColors[1]);
			WRITE_BYTE((int)m_TrailColors[2]);
			WRITE_BYTE(m_TrailBrightness);
		MESSAGE_END();
	}
	pev->dmgtime=gpGlobals->time+m_Fuse;
	pev->nextthink=pev->dmgtime;
	//SetThink(ProjThink);


	// Play sound if we must
	if (m_LaunchSound.set()) EMIT_SOUND_DYN2(edict(),CHAN_ITEM,m_LaunchSound.c_str(),1.0,ATTN_NORM, 0, m_LaunchPitch);

	if (m_TravelSound.set()) EMIT_SOUND_DYN2(edict(),CHAN_VOICE,m_TravelSound.c_str(),1.0,ATTN_NORM, 0, PITCH_NORM);

	// Set the velocity..
	if (pev->owner)
	{
		float vel[3];
		vel[0]=pev->owner->v.v_angle[0] + pev->owner->v.punchangle[0];
		vel[1]=pev->owner->v.v_angle[1] + pev->owner->v.punchangle[1];
		vel[2]=pev->owner->v.v_angle[2] + pev->owner->v.punchangle[2];
		MAKE_VECTORS(vel);
		pev->angles[0] = pev->owner->v.v_angle[0];
		pev->angles[1] = pev->owner->v.v_angle[1];
		pev->angles[2] = pev->owner->v.v_angle[2];
		pev->angles[0] -= 30;
		pev->angles[0] = -(pev->angles[0] + 30);
		pev->velocity[0] = gpGlobals->v_forward[0] * m_Force;
		pev->velocity[1] = gpGlobals->v_forward[1] * m_Force;
		pev->velocity[2] = gpGlobals->v_forward[2] * m_Force;
		//this->m_pfnThink = static_cast<void (CBaseEntity::*)(void)> (&CProjectile::ProjThink);
		if (miscFlags & PROJ_Spin)
		{
			//VEC_TO_ANGLES(pev->velocity,pev->avelocity);
			pev->avelocity[0]=pev->velocity.Length();
			pev->avelocity[1]=0;
			pev->avelocity[2]=0;//pev->velocity[2];
		}
	}
	CSetThink(&CProjectile::ProjThink);

	CSetTouch(&CProjectile::ExpTouch);
}

void CProjectile::Explode(edict_t *e) {

	if (miscFlags & PROJ_Trail) {
		MESSAGE_BEGIN(MSG_ALL,SVC_TEMPENTITY);
			WRITE_BYTE(TE_KILLBEAM);
			WRITE_SHORT(ENTINDEX(edict()));
		MESSAGE_END();
	}
	if (m_ExplodeForward != -1) {
		float orig[3];
		orig[0]=pev->origin[0];
		orig[1]=pev->origin[1];
		orig[2]=pev->origin[2];
		cell c_orig[3] = { amx_ftoc(orig[0]), amx_ftoc(orig[1]), amx_ftoc(orig[2]) };
		cell p_c_orig = MF_PrepareCellArray(c_orig,3);

		// Forward: index of projectile, index of touched entity (-1 for fuse explosion), Vector: last origin of projectile
		if (e == NULL) // Fuse explosion
			MF_ExecuteForward(m_ExplodeForward,ENTINDEX(edict()),-1,p_c_orig);
		else // Contact explosion
			MF_ExecuteForward(m_ExplodeForward,ENTINDEX(edict()),ENTINDEX(e),p_c_orig);

		MF_UnregisterSPForward(m_ExplodeForward);
	}
	if (m_TravelSound.set()) EMIT_SOUND_DYN2(edict(),CHAN_VOICE,m_TravelSound.c_str(),0,0, SND_STOP, PITCH_NORM);
	if (m_LaunchSound.set() && miscFlags & PROJ_StopSound) EMIT_SOUND_DYN2(edict(),CHAN_ITEM,m_LaunchSound.c_str(),0,0, SND_STOP, m_LaunchPitch);
	if (miscFlags & PROJ_DontRemove)
	{
		CSetTouch(NULL);
		CSetThink(NULL);
	}
	else
		Remove();
}
