/* This file is part of AMXX Weapons Module
 * (c) 2004 Steve Dudenhoeffer
 * Licensed under the GNU General Public License version 2.
 * See: http://www.gnu.org/licenses/gpl.txt
 */

#ifndef CBASEPROJECTILE_H
#define CBASEPROJECTILE_H


// Used for bouncing
enum {
	PROJ_Solid		= (1<<0),
	PROJ_Glow		= (1<<1),
	PROJ_Contact	= (1<<2),
	PROJ_Trail		= (1<<3),
	PROJ_Fly		= (1<<4),
	PROJ_Spin		= (1<<5),
	PROJ_StopSound	= (1<<6),
	PROJ_DontRemove	= (1<<7)
};

class CProjectile : public CEntity
{
public:
	CProjectile() {
		m_pfnThink=NULL;
		m_pfnTouch=NULL;
		m_Fuse=0.0;
		m_Force=0.0;
		miscFlags=0;
		m_TrailColors[0]=0.0;
		m_TrailColors[1]=0.0;
		m_TrailColors[2]=0.0;
		m_TrailWidth=0;
		m_TrailLife=0;
		m_TrailIndex=0;
		m_ExplodeForward=0;
		m_Size=1;
		m_HighSpeedThreshold=PROJECTILE_DEFAULT_SPEEDTHRESHOLD;
		m_HighSpeedGroundFriction=PROJECTILE_DEFAULT_HISPEEDFRICTION;
		m_LowSpeedGroundFriction=PROJECTILE_DEFAULT_LOSPEEDFRICTION;
		m_WaterFrictionFactor=PROJECTILE_DEFAULT_WATERFRICTION;
		m_LaunchPitch=PITCH_NORM;

	}
	virtual ~CProjectile() { };
	void ProjThink(void);
	void ExpTouch(edict_t *pOther);
	void ProjSpawn(void);
	void Explode(edict_t *e);
	// Ignore past here..
	int m_ExplodeForward;		// Forward to call for explosion
	String m_Model;			// Model the entity will use, if any
	String m_LaunchSound;	// Sound the projectile will make on launch, if any
	String m_LaunchTrail;	// Sprite the projectile will use on launch, if any
	String m_TravelSound;	// Sound the projectile makes as it's travelling
	int m_TrailIndex;			// Trail the projectile will use on launch, if any
	int m_TrailLife;
	int m_TrailBrightness;
	int m_TrailWidth;
	int m_LaunchPitch;
	float m_TrailColors[3];				// Color for trail
	int miscFlags;						// Various other flags (bitmask)
	float m_Force;						// Force the projectile gets launched at
	float m_Fuse;						// Fuse time for the projectile (semi required)
	int m_HighSpeedThreshold;			// Speed threshold for a non-flying projectile as being classified as high speed
	float m_HighSpeedGroundFriction;	// Friction of a proj when it's travelling fast
	float m_LowSpeedGroundFriction;		// Friction of a proj when it's travelling slow
	float m_WaterFrictionFactor;
};

#endif // CBASEPROJECTIL_H
