/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef CWEAPON_H
#define CWEAPON_H

enum {
	weapontype_undefined=-1,
	weapontype_pistol,
	weapontype_automatic,
	weapontype_handgrenade,
	weapontype_laser
};


/* 
 * Let other forms of weapons derive off of this
 *
 */
class CWeapon
{
public:
	CWeapon() { Clear(); };
	virtual ~CWeapon() { };


	virtual void Holster(CPlayer *player) { return; };
	virtual void Attack2(CPlayer *player) { return; };
	virtual void Attack(CPlayer *player)
	{
		int ret=0;
		// Execute the command...
		if (func_attack)
			ret = MF_ExecuteForward(func_attack,player->index);
		if (!(ret & 1)) // PLUGIN_HANDLED
		{
			player->nextattack[this->id]=gpGlobals->time + this->attack_delay;
			player->pev->weaponanim=this->anim_attack;
			MESSAGE_BEGIN(MSG_ONE,SVC_WEAPONANIM,NULL,player->edict);
			WRITE_BYTE(this->anim_attack);
			WRITE_BYTE(this->weapon_body);
			MESSAGE_END();
		}

	}
	virtual void Draw(CPlayer *player) 
	{
		player->pev->viewmodel=MAKE_STRING(this->viewmodel.c_str());
		player->pev->weaponmodel=MAKE_STRING(this->weaponmodel.c_str());
		MESSAGE_BEGIN(MSG_ONE, SVC_WEAPONANIM, NULL, player->edict);
		WRITE_BYTE(this->anim_draw);
		WRITE_BYTE(this->weapon_body);
		MESSAGE_END();
		player->pev->weaponanim=this->anim_draw;
		player->nextattack[this->id]=gpGlobals->time + deploy_delay;
	};
	virtual void Clear()
	{
		this->type=weapontype_undefined;
		this->anim_attack=0;
		this->anim_draw=0;
		this->anim_holster=0;
		this->anim_idle1=0;
		this->anim_idle2=0;
		this->attack_delay=0;
		this->deploy_delay=0;
		this->event_index=200;
		this->flags=0;
		this->func_altfire=0;
		this->func_attack=0;
		this->func_draw=0;
		this->func_holster=0;
		this->func_reload=0;
		this->func_switch=0;
		this->isStandardWeapon=false;
		this->weapon_body=0;
		for (int i=0;i<=32;i++)
		{
			this->m_ThinkState[i]=0;
		}
	};
	virtual BOOL CanIAttack(CPlayer *player) { 
		if (!player->isDead() && player->nextattack[id] <= gpGlobals->time)
			return TRUE;
		return FALSE;
	};
	virtual void Reload(CPlayer *player) { return; };
	virtual void Think(CPlayer *player) { return; } ;
	
	int id;
	BOOL isStandardWeapon;
	BOOL f_InReload;

	int func_attack;
	int func_altfire;
	int func_reload;
	int func_switch;
	int func_holster;
	int func_draw;
	int event_index;

	REAL fNextThink[33];
	int anim_draw;
	int anim_attack;
	int anim_holster;
	int anim_idle1;
	int anim_idle2;

	int m_ThinkState[33];

	int weapon_body;

	int ammo;

	REAL deploy_delay;
	REAL attack_delay;
	String viewmodel;
	String weaponmodel;
	String name;
	int flags;
	int type;
};

#endif
