/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef LIST_H
#define LIST_H

// minimalistic (and crappy) list class...
template <typename T> class List 
{
private:
    struct LIST {
        T	*m_Data;
        LIST *next;
        LIST *prev;
    };
    LIST *cur;
    LIST *m_first;
    LIST *m_last;
    int m_size;
public:
    List() {
        cur=NULL;
        m_first=NULL;
        m_last=NULL;
        m_size=0;
    };
    ~List() {
        clear();
    };     
    void first() { cur=m_first; };
    void last() { cur=m_last; };
    int size() { return m_size; };
    T *data() { if (cur) return cur->m_Data; return NULL; };
    void erase(LIST *a) {
        LIST *n=a->next;
        LIST *p=a->prev;
        if (a->m_Data)
        	delete a->m_Data;
    	delete a;
		p->next=n;
   	    n->prev=p;
        m_size--;
    };    
    void del() { if (cur) erase(cur); };
    void delnext() { if (cur&&cur->next) erase(cur->next); };
    void delprev() { if (cur&&cur->prev) erase(cur->prev); };
    void next() { if (cur) cur=cur->next; };
    void prev() { if (cur) cur=cur->prev; };
    T *get(int num) {
		LIST *a=m_first;
		num--;
		while (num && a) {
			a=a->next;
			num--;
		}
		if (a)
			return a->m_Data;
		return NULL;
    };    
    void clear() {
        LIST *a,*b;
        a=m_first;
        while (a) {
            b=a->next;
            delete a->m_Data;
            delete a;
            a=b;
        }
        m_size=0;
        m_first=NULL;
        m_last=NULL;
    };
	void add(T *d) {
        LIST *a=new LIST;
        a->m_Data=d;
        if (m_first==NULL) {
            m_first=a;
            m_last=a;
            a->next=NULL;
            a->prev=NULL;
        } else {
            a->prev=m_last;
            a->next=NULL;
            m_last->next=a;
            m_last=a;
        }
        m_size++;
    };
};

#endif // LIST_H
