/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef STRING_H
#define STRING_H
// minimalistic string class
class String
{
private:
    char *m_Str;
    int m_Size;
public:
    String() {
        m_Str=NULL;
        m_Size=0;
        assign("");
    };
    String(String &s) {
        m_Str=NULL;
        m_Size=0;
        assign(s.c_str());
    };
    String(const String *s) {
        m_Str=NULL;
        m_Size=0;
        assign(s->c_str());
    };
    String(const char *s) {
        m_Str=NULL;
        m_Size=0;
        assign(s);
    };    
    ~String() {
        if (m_Str!=NULL)
        	delete[] m_Str;
    };       
    // normal c_str(), but this returns the given value if m_Str is null...
    const char *c_str(const char *s=NULL) { if (m_Size<=1) return s; return m_Str?m_Str:s; };
    const char *c_str(const char *s=NULL) const { if (m_Size<=1) return s; return m_Str?m_Str:s; };
    void assign(const char *s) {
        m_Size=strlen(s)+1;
        char *d = new char[m_Size];
        strcpy(d,s);
        if (m_Str) // incase it's already assigned..
        	delete[] m_Str;
        m_Str=d;
    };
    void append(const char *s) {
		ASSERT(m_Str!=NULL);
        m_Size+=strlen(s);
        char *d = new char[m_Size];
        strncpy(d,m_Str,m_Size);
        strncat(d,s,m_Size);
        assign(d);
        delete[] d;
    };    
    int iseq(char c,char *list) {
        while (list && *list!='\0') {
        	if (c==*list) return 1;
        	list++;
		}   	
		return 0;
    };
    void truncate(char *s) {
        if (!m_Str || m_Size<=0 || !s) return;
        char *b= new char[m_Size];
        char *start=b;
        strcpy(b,m_Str);
        if (!strncmp(s,b,strlen(s))) {
            start+=strlen(s);
        }
        assign(start);
        delete[] b;
    };    
    void trim(char *list=NULL) {
        if (!m_Str || m_Size<=0) return;
        if (list==NULL) list=" \t\n\r"; // default characters to trim..
		char *b=new char[m_Size];
		char *start=b;
        strcpy(b,m_Str);
        // trim front..
		while(b && iseq(*b,list) && m_Size) { start=b+1; --m_Size; b++; };
		assign(start);
		delete[] b;
	
		// trim back...
		b=m_Str;
		b+=(strlen(m_Str) - 1);
		while (b && iseq(*b,list) && m_Size && b!=m_Str) { *b='\0'; --m_Size; b--; };
		assign(m_Str);
    }    
    int set() { if (m_Str==NULL || m_Size<=1) return 0; return m_Size; };
    void assign(String s) { assign(s.c_str()); };
    void assign(String *s) { assign(s->c_str()); };
    int len() { return m_Size-1; };
    int comp(const char *a) { return strcmp(c_str(),a); };
    int compn(const char *a, size_t s) { return strncmp(c_str(),a,s); };
    int comp(String a) { return strcmp(c_str(),a.c_str()); };
    int comp(const String *a) { return strcmp(c_str(),a->c_str()); };
    int compn(String a, size_t s) { return strncmp(c_str(),a.c_str(),s); };
    int compn(const String *a, size_t s) { return strncmp(c_str(),a->c_str(),s); };
	char operator [] (int i) {
	    if (i>m_Size) { return '\0'; };
	    return m_Str[i];
	};
	int operator == (const char *s) { return !strcmp(c_str(),s); };
	int operator == (const String *s) { return !strcmp(c_str(),s->c_str());	};
	int operator == (String s) { return !strcmp(c_str(),s.c_str());	};
	int operator >= (const char *s) { return (strlen(c_str()) >= strlen(s)); };    
	int operator >= (const String *s) { return (strlen(c_str()) >= strlen(s->c_str())); };    
	int operator >= (String s) { return (strlen(c_str()) >= strlen(s.c_str())); };    
	int operator > (const char *s) { return (strlen(c_str()) > strlen(s)); };    
	int operator > (const String *s) { return (strlen(c_str()) > strlen(s->c_str())); };    
	int operator > (String s) { return (strlen(c_str()) > strlen(s.c_str())); };    
	int operator <= (const char *s) { return (strlen(c_str()) <= strlen(s)); };    
	int operator <= (const String *s) { return (strlen(c_str()) <= strlen(s->c_str())); };    
	int operator <= (String s) { return (strlen(c_str()) <= strlen(s.c_str())); };    
	int operator < (const char *s) { return (strlen(c_str()) < strlen(s)); };    
	int operator < (const String *s) { return (strlen(c_str()) < strlen(s->c_str())); };    
	int operator < (String s) { return (strlen(c_str()) < strlen(s.c_str())); };    
	int operator != (const char *s) { return strcmp(c_str(),s); };
	int operator != (String s) { return strcmp(c_str(),s.c_str()); };
	int operator != (const String *s) { return strcmp(c_str(),s->c_str()); };
	String &operator = (const char *s) { assign(s); return *this; };
	String &operator = (String s) { assign(s.c_str()); return *this; };
   	String &operator = (const String *s) { assign(s->c_str()); return *this; };

};
inline int strcmp(String a, const String b) { return strcmp(a.c_str(),b.c_str()); };
inline int strcmp(const String *a, String b) { return strcmp(a->c_str(),b.c_str()); };
inline int strcmp(const String *a, const String *b) { return strcmp(a->c_str(),b->c_str()); };
inline int strcmp(String a, const String *b) { return strcmp(a.c_str(),b->c_str()); };

inline int strcmp(const char *a, String b) { return strcmp(a,b.c_str()); };
inline int strcmp(const char *a, const String *b) { return strcmp(a,b->c_str()); };
inline int strcmp(String a, const char *b) { return strcmp(a.c_str(),b); };
inline int strcmp(const String *a, const char *b) { return strcmp(a->c_str(),b); };

inline int strncmp(String a, String b, size_t s) { return strncmp(a.c_str(),b.c_str(),s); };
inline int strncmp(const String *a, String b, size_t s) { return strncmp(a->c_str(),b.c_str(),s); };
inline int strncmp(const String *a, const String *b, size_t s) { return strncmp(a->c_str(),b->c_str(),s); };
inline int strncmp(String a, const String *b, size_t s) { return strncmp(a.c_str(),b->c_str(),s); };

inline int strncmp(const char *a, String b, size_t s) { return strncmp(a,b.c_str(),s); };
inline int strncmp(const char *a, const String *b, size_t s) { return strncmp(a,b->c_str(),s); };
inline int strncmp(String a, const char *b, size_t s) { return strncmp(a.c_str(),b,s); };
inline int strncmp(const String *a, const char *b, size_t s) { return strncmp(a->c_str(),b,s); };

inline int strlen(String a) { return strlen(a.c_str()); };
inline int strlen(const String *a) { return strlen(a->c_str()); };



#endif // STRING_H

