/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

CGameBase *game=NULL;
int weaponInit;
void GameInit()
{
	if (game==NULL) // make sure the game is not already initialized before doing this
	{
		LINK_GAME("nsp",CGameNS,GAME_NS);
		LINK_GAME("ns",CGameNS,GAME_NS);
		LINK_GAME("valve",CGameDMC,GAME_VALVE);
		LINK_GAME("tfc",CGameBase,GAME_TFC);
		LINK_GAME("dmc",CGameDMC,GAME_DMC);
		LINK_GAME("cstrike",CGameCS,GAME_CSTRIKE);
		LINK_GAME("czero",CGameCS,GAME_CSTRIKE);
		LINK_GAME("dod",CGameDoD,GAME_DOD);

		// The loaded game was not recognized
		// Revert to default, but notify the server console that it may not go as planned
		if (game==NULL) {
			MF_Log("Did not find a class to link the game `%s` to. Reverting to default usage.",MF_GetModname());
			MF_Log("Note: The module and relating plugins may operate awkwardly.");
			game=new CGameBase;
			game->type=GAME_UNKNOWN;
		}
	}
}
void clearEntities(int del)
{
	int i=2047;
	if (del)
	{
		while (i>=0) {
			if (g_entities[i])
				delete g_entities[i];
			g_entities[i]=NULL;
			--i;
		}
	}
	else
	{
		while (i>=0) {
			g_entities[i]=NULL;
			--i;
		}
	}
}
void OnAmxxAttach()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
	clearEntities(0); // 0 means do NOT delete any entries with non null pointers
	GameInit();
	MF_AddNatives(weapons_natives);
	MF_AddNatives(projectiles_natives);
	MF_AddNatives(misc_natives);
	MF_AddNatives(explosion_natives);
	MF_AddNatives(snark_natives);
	MF_AddNatives(generic_natives);
}
void OnPluginsLoaded()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
	GameInit();
	clearEntities(1);
	// Reset weapons
	for (int i=0;i<=(MODULE_MAX_WEAPONS + 31);i++)
	{
		// Dealloc all weapons...
		CWeapon *weap = GET_WEAPON(i);
		if (weap)
			delete weap;
		weap=NULL;
	}
	for (int i=0;i<=32;i++)
	{
		// Allocate the base (32) weapons...
		g_weapon[i]=new CWeapon;
		CWeapon *weap = GET_WEAPON(i);
		weap->Clear();
		weap->isStandardWeapon=true;
		weap->id=i;
	}
	currentWeap=32;
	// Register "weapons_init"
	weaponInit = MF_RegisterForward("weapons_init",ET_IGNORE,FP_DONE);
	// loop through players
	for (int i=1;i<=gpGlobals->maxClients;i++)
	{
		CPlayer *p=GET_PLAYER_I(i);
		if (INDEXENT2(i))
			p->pev=&INDEXENT2(i)->v;
	}
}
