/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"
#include <usercmd.h>
#include <sdk_util.h> //useful almost everywhere
#include <entity_state.h>
CPlayer		g_player[33];
CWeapon		*g_weapon[MODULE_MAX_WEAPONS+32];
//CWList			wl;

edict_t		*g_player_edicts[33];
int			g_msgHook=FALSE;
int			currentWeap=32;
int			gmsgCurWeapon;
int			gmsgWeaponList;

int			msg_hook;
edict_t		*msg_ed;
META_RES alertRes=MRES_IGNORED;



typedef struct curweapon_s
{
	// Basic message stuffs...
	int target; // 1-32
	int parts; // SHOULD BE 3 -ALWAYS-
	
	int active;
	int weaponid;
	int ammo;

} curweapon_t;
curweapon_t	curweapon;
typedef struct weaponlist_s
{
	// Basic
	int target; // 1-32
	int parts; // Should -always- be 9

	char weapon_name[192];
	int ammotype;
	int ammomax;
	int secondaryammo;
	int damage;
	int slot;
	int slotpos;
	int id;
	int flags;
} weaponlist_t;
weaponlist_t	weaponlist;

void ClientDisconnect(edict_t *pEntity)
{
	CPlayer *player = GET_PLAYER_E(pEntity);
	player->Disconnect();	
	RETURN_META(MRES_IGNORED);
}
void ClientPutInServer(edict_t *pEntity)
{
	CPlayer *player = GET_PLAYER_E(pEntity);
	player->PutInServer(pEntity);
	RETURN_META(MRES_IGNORED);
}
void ServerActivate_Post(edict_t *pEdictList, int edictCount, int clientMax)
{
	g_msgHook=TRUE;
	GameInit();
	for(int f = 1; f <= gpGlobals->maxClients;f++) 
	{
		g_player_edicts[f]=pEdictList + f;
		CPlayer *player = GET_PLAYER_I(f);
		player->edict=pEdictList+f;
	}
	for (int i=1;i<=gpGlobals->maxClients;i++)
	{
		CPlayer *p=GET_PLAYER_I(i);
		if (INDEXENT2(i))
			p->pev=&INDEXENT2(i)->v;
	}
	if (game)
		game->initialize(); // HLSDK standard for registering message is ServerActivate, not worldspawn spawn (I'm an idiot.)
	RETURN_META(MRES_IGNORED);
}
void PlayerPreThink(edict_t *pEntity)
{
	CPlayer *player = GET_PLAYER_E(pEntity);
	if (!player->connected)
		player->PutInServer(pEntity);
	player->PreThink();
	RETURN_META(MRES_IGNORED);
}
int Spawn_Post(edict_t *pEntity)
{
	if (FClassnameIs(pEntity,"worldspawn"))
	{
		GameInit();
		game->Precache();
		MF_ExecuteForward(weaponInit);
	}
	RETURN_META_VALUE(MRES_IGNORED,0);
}
void UpdateClientData(const struct edict_s *ent, int sendweapons, struct clientdata_s *cd)
{
	gpGamedllFuncs->dllapi_table->pfnUpdateClientData(ent, sendweapons, cd);
	edict_t *pEntity = (edict_t*)ent;
	CPlayer *player = GET_PLAYER_E(pEntity);
	if (player->curweapon != NULL)
	{
		if (!player->curweapon->isStandardWeapon)
		{
			cd->m_iId=player->curweapon->event_index;
		}
	}
	RETURN_META(MRES_SUPERCEDE);
}
/* We check attacks here since this method works better than player prethink */
void CmdStart( const edict_t *pEntity, const struct usercmd_s *_cmd, unsigned int random_seed )
{
	CPlayer *player = GET_PLAYER_E((edict_t*)pEntity);
	usercmd_t *cmd = (usercmd_t*)_cmd;
	player->f_AttackLast=player->f_AttackThis;
	if (cmd->buttons & IN_ATTACK)
	{
		if (player->Attack()==TRUE)
		{
			player->f_AttackThis=TRUE;
			cmd->buttons &= ~IN_ATTACK;
			//player->f_AttackLast=TRUE;
		}
		else
			player->f_AttackThis=FALSE;
	}
	else
		player->f_AttackThis=FALSE;
	player->f_Attack2Last=player->f_Attack2This;
	player->f_Attack2This=FALSE;
	if (cmd->buttons & IN_ATTACK2)
	{
		if (player->Attack2()==TRUE)
		{
			cmd->buttons &= ~IN_ATTACK2;
			//player->f_Attack2Last=TRUE;
		}
	}
	RETURN_META(MRES_IGNORED);
}
void PlayerPostThink_Post(edict_t *pEntity)
{
	CPlayer *player = GET_PLAYER_E(pEntity);
	player->f_AttackThis=FALSE;
	RETURN_META(MRES_IGNORED);
}
void ServerDeactivate(void)
{
	g_msgHook=FALSE;
	RETURN_META(MRES_IGNORED);
}

