/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"


static cell AMX_NATIVE_CALL create_explosion(AMX *amx, cell *params)
{
	CExplosion *exp = MakeEnt((CExplosion*)NULL);
	cell *c = MF_GetAmxAddr(amx,params[1]);
	float orig[3] = {amx_ctof(c[0]),amx_ctof(c[1]),amx_ctof(c[2])};

	SET_ORIGIN(exp->edict(),orig);
	return ENTINDEX(exp->edict());
}
static cell AMX_NATIVE_CALL explosion_config(AMX *amx, cell *params)
{
	if (params[1] <= gpGlobals->maxClients || params[1] > gpGlobals->maxEntities)
	{
		MF_Log("Invalid entity index in explosion_config. (Got: %d)",params[1]);
		return 0;
	}
	CExplosion *obj=NULL;
	edict_t *p=INDEXENT(params[1]); 
	obj=ENT_PRIVATE(CExplosion,p);
	char *itemKeyName=NULL;
	char *itemValue=NULL;
	int len;
	itemKeyName=MF_GetAmxString(amx,params[2],0,&len);
	itemValue=MF_GetAmxString(amx,params[3],1,&len);
	
	NATIVE_KEYVALUE_INT(m_Exp_Sprite,"explosionspriteindex");
	NATIVE_KEYVALUE_INT(m_Exp_WaterSprite,"explosionwaterspriteindex");
	NATIVE_KEYVALUE_INT(m_BubbleIndex,"bubblespriteindex");
	NATIVE_KEYVALUE_INT(m_BubbleAmount,"bubbleamount");
	NATIVE_KEYVALUE_INT(m_Exp_Framerate,"explosionframerate");
	NATIVE_KEYVALUE_INT(m_Exp_Flags,"explosionflags");
	NATIVE_KEYVALUE_INT(m_Smo_Sprite,"smokespriteindex");
	NATIVE_KEYVALUE_INT(m_Smo_FrameRate,"smokeframerate");
	NATIVE_KEYVALUE_FLOAT(m_Damage_Radius,"damageradius");
	NATIVE_KEYVALUE_FLOAT(m_Damage,"damage");
	NATIVE_KEYVALUE_INT(m_Intensity,"intensity");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_Explosion,"explosion");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_Decals,"decal");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_Smoke,"smoke");
	NATIVE_KEYVALUE_INT(m_Spa_Num,"sparks");
	NATIVE_KEYVALUE_INT(m_BubbleSize,"bubbleoriginsize");
	NATIVE_KEYVALUE_INT(m_BubbleHeight,"bubbleheight");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_NeverBubble,"neverbubble");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_NeverSmoke,"neversmoke");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_AlwaysBubble,"alwaysbubble");
	NATIVE_KEYVALUE_BIT(m_Flags,EXP_AlwaysSmoke,"alwayssmoke");
	NATIVE_KEYVALUE_STRING(m_Decal2,"decal1");
	NATIVE_KEYVALUE_STRING(m_Decal2,"decal2");

	return 0;
}
static cell AMX_NATIVE_CALL explosion_explode(AMX *amx, cell *params)
{
	int index=params[1];
	if (index<=gpGlobals->maxClients || index>gpGlobals->maxEntities)
	{
		MF_LogError(amx,AMX_ERR_NATIVE,"Invalid explosion.");
		return 1;
	}
	edict_t *i = INDEXENT(index);
	CExplosion *e = ENT_PRIVATE(CExplosion,i);
	e->Explode();
	return 0;
}

AMX_NATIVE_INFO explosion_natives[] = {
	{	"explosion_create",		create_explosion	},
	{	"explosion_explode",	explosion_explode	},
	{	"explosion_config",		explosion_config	},
	{	NULL,					NULL				}
};

