/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

NATIVE(generic_create) {
    CHECK_PARAMS(0);
    CGenericEntity *a = MakeEnt((CGenericEntity*)NULL);
    if (a == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Could not create CGenericEntity class.");
        return 0;
    }    
    return ENTINDEX(a->pev->pContainingEntity);
};
NATIVE(generic_get_int) {
    CHECK_PARAMS(2);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_INT-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for integer data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_INT-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    return ent->idata[params[2]];
};    
NATIVE(generic_set_int) {
    CHECK_PARAMS(3);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_INT-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for integer data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_INT-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    return (ent->idata[params[2]]=params[3]);
};
NATIVE(generic_get_float) {
    CHECK_PARAMS(2);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_FLOAT-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for float data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_FLOAT-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    return amx_ftoc(ent->fdata[params[2]]);
};  
NATIVE(generic_set_float) {
    CHECK_PARAMS(3);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_FLOAT-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for float data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_FLOAT-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    ent->fdata[params[2]]=amx_ctof(params[3]);
    return 1;
};  
NATIVE(generic_get_string) {
    CHECK_PARAMS(4);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_STRING-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for string data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_STRING-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    if (params[4] <= 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid string size (got: %d)",params[4]);
        return 0;
    }    
    MF_SetAmxString(amx,params[3],ent->sdata[params[2]].c_str(""),params[4]);
    return 1;
};  
NATIVE(generic_set_string) {
    CHECK_PARAMS(3);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    if (params[2] > (GENERIC_ENTITY_MAX_FLOAT-1) || params[2] < 0) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index for float data. (got: %d min: 0 max: %d)",params[2],GENERIC_ENTITY_MAX_FLOAT-1);
        return 0;
    }    
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    char *s = MF_GetAmxString(amx,params[3],0,NULL);
    ent->sdata[params[2]].assign(s);
    return 1;
};
NATIVE(generic_set_touch) {
    CHECK_PARAMS(2);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    char *func_str = MF_GetAmxString(amx,params[2],0,NULL);
    int iFunctionIndex;
    if (MF_AmxFindPublic(amx, func_str, &iFunctionIndex) != AMX_ERR_NONE) {
        MF_LogError(amx,AMX_ERR_NATIVE,"%s: Public function not found (function: %s)",__FUNCTION__,func_str);
        return 0;
    }    
    ent->touchForward=MF_RegisterSPForwardByName(amx,func_str,FP_CELL,FP_CELL,FP_DONE);
    return 1;
    
};    
NATIVE(generic_clear_touch) {
    CHECK_PARAMS(1);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    if (ent->touchForward != -1) {
        MF_UnregisterSPForward(ent->touchForward);
    }    
    ent->touchForward=-1;
    return 1;
    
};    
NATIVE(generic_set_think) {
    CHECK_PARAMS(2);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    char *func_str = MF_GetAmxString(amx,params[2],0,NULL);
    int iFunctionIndex;
    if (MF_AmxFindPublic(amx, func_str, &iFunctionIndex) != AMX_ERR_NONE) {
        MF_LogError(amx,AMX_ERR_NATIVE,"%s: Public function not found (function: %s)",__FUNCTION__,func_str);
        return 0;
    }    
    ent->thinkForward=MF_RegisterSPForwardByName(amx,func_str,FP_CELL,FP_DONE);
    return 1;
    
};    
NATIVE(generic_clear_think) {
    CHECK_PARAMS(1);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    if (ent->thinkForward != -1) {
        MF_UnregisterSPForward(ent->thinkForward);
    }    
    ent->thinkForward=-1;
    return 1;
    
};    
NATIVE(generic_remove) {
    CHECK_PARAMS(1);
    if (params[1] > gpGlobals->maxEntities || params[1] <= gpGlobals->maxClients) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Invalid generic entity index given (%d)",params[1]);
        return 0;
    }
    CHECK_ENTITY(params[1]);
    CGenericEntity *ent = ENT_PRIVATE(CGenericEntity,INDEXENT2(params[1]));
    if (ent == NULL) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) does not have CEntity private data assigned to it.",params[1]);
        return 0;
    }
    if (!ent->isGeneric()) {
        MF_LogError(amx,AMX_ERR_NATIVE,"Entity (%d) has CEntity private data, but is not a CGenericyEntity.",params[1]);
        return 0;
    }
    ent->Remove();
    return 1;
    
};    

AMX_NATIVE_INFO generic_natives[] = {
    { "generic_create",			generic_create		},
    { "generic_get_int",		generic_get_int		},
    { "generic_set_int",		generic_set_int		},
    { "generic_get_float",		generic_get_float	},
    { "generic_set_float",		generic_set_float	},
    { "generic_get_string",		generic_get_string	},
    { "generic_set_string",		generic_set_string	},
    { "generic_set_touch",		generic_set_touch	},
    { "generic_clear_touch",	generic_clear_touch	},
    { "generic_set_think",		generic_set_think	},
    { "generic_clear_think",	generic_clear_think	},
    { "generic_remove",			generic_remove		},
    { NULL,						NULL				}
};    
