/* This file is part of AMXX WTF Module
 * (c) 2004 Steve Dudenhoeffer
 * Licensed under the GNU General Public License version 2.
 * See: http://www.gnu.org/licenses/gpl.txt
 */
 
#if defined _wtf_included
  #endinput
#endif
#define _wtf_included


enum WeaponType {
	weapontype_pistol = 0,
	weapontype_automatic,
	weapontype_handgrenade,
	weapontype_laser
}

/* Registers a weapon, returns it's weapon index */
native Weapon:register_weapon(WeaponType:x);

/* Configures the weapon */
native weapon_config(Weapon:weap,_keyName[],_keyValue[]);

/* Forces the player to draw this weapon. */
native weapon_draw(idPlayer,Weapon:weap);

/* Returns an entity index for a projectile. */
native projectile_create(_owner=0);

/* Configures a projectile */
native projectile_config(_proj,_keyName[],_keyValue[]);

/* Launches a projectile, call this after all projectile_config's are finished. */
native projectile_launch(_proj);

native explosion_create(Float:_origin[3]);

native explosion_config(_explosionID,_keyName[],_keyValue[]);

native explosion_explode(_exp);

/* Create a snark! */
native snark_create(_owner=0);

/* Configure the snark. */
native snark_config(_snarkID,_keyName[],_keyValue[]);

/* Launch the snark */
native snark_launch(_snark);

/* Create a generic entity.  If you must change it's classname, it must be preceded by "wmod_" (ie: wmod_nuke) */
native generic_create();

/* Gets some of the generic entity's private data.  Up to 50 integers (0-49)  can be stored */
native generic_get_int(_generic,_num);

/* Sets some of the generic entity's private data. Up to 50 integers (0-49) can be stored */
native generic_set_int(_generic,_num,_value);

/* Gets some of the generic entity's private data. Up to 50 floats (0-49) may be stored */
native Float:generic_get_float(_generic,_num);

/* Sets some of the generic entity's private data. Up to 50 floats (0-49) may be stored */
native generic_set_float(_generic,_num,Float:_value);

/* Gets some of the generic entity's private data. Up to 50 strings (0-49) may be stored */
native generic_get_string(_generic,_num,_strArray[],_strSize);

/* Sets some of the generic entity's private data. Up to 50 strings (0-49) may be stored */
native generic_set_string(_generic,_num,_strArray[]);

/* Set the command to forward when the generic entity gets touched by something.
   Forwarded params are: command(idGeneric,idTouched) */
native generic_set_touch(_generic,_command[]);

/* Stops forwarding touches from this entity */
native generic_clear_touch(_generic);

/* Set the command to forward when the generic entity thinks.
   Forwarded params are: command(idGeneric) */
native generic_set_think(_generic,_command[]);

/* Stops forwarding thinks from this entity */
native generic_clear_think(_generic);

