/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

//CLogs l;
extern List<String> LogData;
void AlertMessage(ALERT_TYPE atype, char *szFmt, ...)
{
	if (atype != at_logged)
		RETURN_META(MRES_IGNORED); // do nothing
	LogData.clear();
	va_list LogArg;
	char *sz, *message;
	const char *b;
	char szParm[1024];
	int argc,len;
	va_start(LogArg, szFmt);
	sz = va_arg(LogArg, char *);
	va_end(LogArg);
	message = sz;
	b=message;
	argc=0;
	String *temp;
	// Parse the damn message
	while (*b && *b!='\0')
	{

		len=0;
		if (*b == '"')
		{
			b++; // Skip over the "
			while (*b && *b != '"' && len < 127)
			{
				szParm[len]=*b;
				b++;
				len++;
			}
			//*szParm='\0';
			szParm[len]='\0';
			temp = new String;
			temp->assign(szParm);
			temp->trim();
			LogData.add(temp);

			if (*b && *b == '"' && *b+1 != '\0' && *b+2 != '\0')
				b+=2;
			else
				break;
		}
		else if (*b == '(')
		{
			b++; // Skip over the (
			while (*b && *b != ')' && len < 127)
			{
				szParm[len]=*b;
				b++;
				len++;
			}
			szParm[len]='\0';
			temp = new String;
			temp->assign(szParm);
			temp->trim();
			LogData.add(temp);
			if (*b && *b == ')' && *b+1 != '\0' && *b+2 != '\0')
				b+=2;

			else
				break;
		}
		else
		{
			while (*b && *b != '"' && *b != '(' && len < 127)
			{
				szParm[len]=*b;
				b++;
				len++;
			}
			szParm[len]='\0';
			temp = new String;
			temp->assign(szParm);
			temp->trim();
			LogData.add(temp);
			if (*b != '"' && *b != '(' && *b != '\0' && *b+1 != '\0' && *b+2 != '\0')
				b+=2;

			else
			{
				if (*b == '\0')
					break;
			}

		}
		
		
	}
	game->Log();
	LogData.clear();
	RETURN_META(alertRes);
}
