/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

static cell AMX_NATIVE_CALL wmod_explosion(AMX *amx, cell *params)
{
	return 1;
};
static cell AMX_NATIVE_CALL radial_damage(AMX *amx, cell *params)
{
	int index=params[1];
	CHECK_ENTITY(index);
	edict_t *ent = INDEXENT2(index);

	char *str = MF_GetAmxString(amx,params[2],0,NULL);
	String s;
	s.assign(str);

	REAL flDamage=amx_ctof(params[3]);

	REAL flRadius=amx_ctof(params[4]);

	if (game)
		game->RadialDamage(ent,&s, flDamage, flRadius );
	else
	{
		MF_Log("No game linked yet.");
		return 0;
	}
	return 1;
};
static cell AMX_NATIVE_CALL take_damage(AMX *amx, cell *params)
{
	int idVictim;
	int idAttacker;
	char *inflictor;
	REAL damage;
	idVictim=params[1];
	idAttacker=params[2];
	inflictor=MF_GetAmxString(amx,params[3],0,NULL);

	String s;
	s.assign(inflictor);
	damage=amx_ctof(params[4]);
	if (!game)
	{
		MF_Log("Error: Game not initialized before calling damage native.");
		return 0;
	}
	// configure armor absorbtion
	game->m_ArmorAbsorb=amx_ctof(params[5]);
	game->m_ArmorValue=amx_ctof(params[6]);
	game->TakeDamage(INDEXENT2(idVictim),INDEXENT2(idAttacker),&s,damage);
	return 1;
};
AMX_NATIVE_INFO misc_natives[] = {
	{ "wmod_explosion",		wmod_explosion		},
	/*
	{ "take_damage",		take_damage			},
	{ "radial_damage",		radial_damage		},*/
	{ NULL,					NULL				}
};

