/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"


static cell AMX_NATIVE_CALL create_projectile(AMX *amx, cell *params)
{
	CProjectile *proj = MakeEnt((CProjectile *)NULL);
	proj->pev->owner=INDEXENT2(params[1]);
	return ENTINDEX(proj->edict());
}
static cell AMX_NATIVE_CALL projectile_launch(AMX *amx, cell *params)
{
	if (params[1] <= gpGlobals->maxClients || params[1] > gpGlobals->maxEntities)
	{
		MF_Log("Invalid entity index in projectile_launch. (Got: %d)",params[1]);
		return 0;
	}
	CProjectile *proj=NULL;
	edict_t *p=INDEXENT(params[1]); 
	proj=ENT_PRIVATE(CProjectile,p);
	proj->ProjSpawn();
	return 1;
}
static cell AMX_NATIVE_CALL projectile_config(AMX *amx, cell *params)
{
	if (params[1] <= gpGlobals->maxClients || params[1] > gpGlobals->maxEntities)
	{
		MF_Log("Invalid entity index in projectile_config. (Got: %d)",params[1]);
		return 0;
	}
	CProjectile *obj=NULL;
	edict_t *p=INDEXENT(params[1]); 
	obj=ENT_PRIVATE(CProjectile,p);
	char *itemKeyName=NULL;
	char *itemValue=NULL;
	int len;
	itemKeyName=MF_GetAmxString(amx,params[2],0,&len);
	itemValue=MF_GetAmxString(amx,params[3],1,&len);
	NATIVE_KEYVALUE_FORWARD(m_ExplodeForward,"explodeforward",(amx,itemValue,FP_CELL,FP_CELL,FP_ARRAY,FP_DONE));
	NATIVE_KEYVALUE_STRING(m_Model,"model");
	NATIVE_KEYVALUE_STRING(m_LaunchSound,"launchsound");
	NATIVE_KEYVALUE_STRING(m_TravelSound,"trailsound");
	NATIVE_KEYVALUE_STRING(m_LaunchTrail,"trailmodel");
	NATIVE_KEYVALUE_INT(m_TrailWidth,"trailwidth");
	NATIVE_KEYVALUE_INT(m_TrailBrightness,"trailbright");
	NATIVE_KEYVALUE_FLOAT(m_TrailColors[0],"trailred");
	NATIVE_KEYVALUE_FLOAT(m_TrailColors[1],"trailgreen");
	NATIVE_KEYVALUE_FLOAT(m_TrailColors[2],"trailblue");
	NATIVE_KEYVALUE_INT(m_TrailLife,"traillife");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_Glow,"glow");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_Solid,"solid");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_Contact,"contact");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_StopSound,"stopsound");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_Spin,"spin");
	NATIVE_KEYVALUE_BIT(miscFlags,PROJ_Fly,"fly");
	NATIVE_KEYVALUE_FLOAT(m_Force,"force");
	NATIVE_KEYVALUE_FLOAT(m_Fuse,"fuse");
	NATIVE_KEYVALUE_INT(m_LaunchPitch,"pitch");
	NATIVE_KEYVALUE_INT(m_Size,"size");

	MF_Log("Unknown projectile_config option `%s` (maybe updated module available?)",itemKeyName);
	return 0;
}
AMX_NATIVE_INFO projectiles_natives[] = {
	{ "projectile_create",	create_projectile	},
	{ "projectile_config",	projectile_config	},
	{ "projectile_launch",	projectile_launch	},
	{ NULL,					NULL				}
};

