/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"
static cell AMX_NATIVE_CALL create_snark(AMX *amx, cell *params)
{
	CSnark *snark = MakeEnt((CSnark*)NULL);
	snark->pev->owner=NULL;
	if (params[1] > 0)
		snark->pev->owner=INDEXENT2(params[1]);

	snark->Setup(snark->pev->owner);
	return ENTINDEX(snark->pev->pContainingEntity);
}
static cell AMX_NATIVE_CALL snark_config(AMX *amx, cell *params) 
{
	if (params[1] <= gpGlobals->maxClients || params[1] > gpGlobals->maxEntities)
	{
		MF_Log("Invalid entity index in snark_config. (Got: %d)",params[1]);
		return 0;
	}
	CSnark *obj=NULL;
	edict_t *p=INDEXENT(params[1]); 
	obj=ENT_PRIVATE(CSnark,p);
	char *itemKeyName=NULL;
	char *itemValue=NULL;
	int len;
	itemKeyName=MF_GetAmxString(amx,params[2],0,&len);
	itemValue=MF_GetAmxString(amx,params[3],1,&len);
	NATIVE_KEYVALUE_STRING(m_SnarkModel,"model");
	NATIVE_KEYVALUE_FLOAT(m_DamageBite,"bitedamage");
	NATIVE_KEYVALUE_FLOAT(m_Damage,"popdamage");
	NATIVE_KEYVALUE_FLOAT(m_Life,"lifespan");
	NATIVE_KEYVALUE_FLOAT(m_Health,"health");
	NATIVE_KEYVALUE_STRING(m_Classname,"classname");
	NATIVE_KEYVALUE_FLOAT(m_Speed,"speed");
	NATIVE_KEYVALUE_INT(m_LaunchSequence,"launchsequence");
	NATIVE_KEYVALUE_FLOAT(m_Mins[0],"minsx");
	NATIVE_KEYVALUE_FLOAT(m_Mins[1],"minsy");
	NATIVE_KEYVALUE_FLOAT(m_Mins[2],"minsz");
	NATIVE_KEYVALUE_FLOAT(m_Maxs[0],"maxsx");
	NATIVE_KEYVALUE_FLOAT(m_Maxs[1],"maxsy");
	NATIVE_KEYVALUE_FLOAT(m_Maxs[2],"maxsz");
	
	NATIVE_KEYVALUE_STRING(m_BlastSound,"blastsound");
	NATIVE_KEYVALUE_STRING(m_DieSound,"diesound");
	NATIVE_KEYVALUE_STRING(m_BiteSound,"bitesound");
	NATIVE_KEYVALUE_STRING(m_HuntSound1,"huntsound1");
	NATIVE_KEYVALUE_STRING(m_HuntSound2,"huntsound2");
	NATIVE_KEYVALUE_STRING(m_HuntSound3,"huntsound3");
	
	
	MF_Log("Unknown snark_config option `%s` (maybe updated module available?)",itemKeyName);
	return 1;

}    
static cell AMX_NATIVE_CALL snark_launch(AMX *amx, cell *params)
{
	if (params[1] <= gpGlobals->maxClients || params[1] > gpGlobals->maxEntities)
	{
		MF_Log("Invalid entity index in projectile_launch. (Got: %d)",params[1]);
		return 0;
	}
	printf("launching snark\n");
	CSnark *snark=NULL;
	edict_t *p=INDEXENT(params[1]); 
	snark=ENT_PRIVATE(CSnark,p);
	snark->Spawn();
	return 1;
}
AMX_NATIVE_INFO snark_natives[] = {
	{ "snark_create",	create_snark	},
	{ "snark_config",	snark_config	},
	{ "snark_launch",	snark_launch	},
	{ NULL			,	NULL			}
};

