/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

CMessageInfo msg;
void MessageBegin(int msg_dest, int msg_type, const float *pOrigin, edict_t *ed)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (game->isHook(msg_type))
	{
		msg.hooked=TRUE;
		msg.msg_dest=msg_dest;
		msg.msg_type=msg_type;
		msg.msg_loc=(float*)pOrigin;

		msg.msg_ed=ed;
	}
	else
		msg.hooked=FALSE;

	RETURN_META(msg.result);
}
void WriteByte(int i)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(i,MSG_Byte);
	RETURN_META(msg.result);
}
void WriteChar(int i)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(i,MSG_Char);
	RETURN_META(msg.result);
}
void WriteShort(int i)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(i,MSG_Short);
	RETURN_META(msg.result);
}
void WriteLong(int i)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(i,MSG_Long);
	RETURN_META(msg.result);
}
void WriteEntity(int i)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(i,MSG_Entity);
	RETURN_META(msg.result);
}
void WriteCoord(float f)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(f,MSG_Coord);
	RETURN_META(msg.result);
}
void WriteAngle(float f)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(f,MSG_Angle);
	RETURN_META(msg.result);
}
void WriteString(const char *s)
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
		msg.add(s,MSG_String);
	RETURN_META(msg.result);
}
void MessageEnd()
{
	RETURN_META(msg.result);
}
void MessageEnd_Post()
{
	if (!g_msgHook) 
		RETURN_META(MRES_IGNORED);
	if (msg.hooked==TRUE)
	{
		//game->execMessage(msg.msg_type,&msg);
		game->executeMessage(&msg);
		msg.clear();
	}
	RETURN_META(MRES_IGNORED); // can't block posts
}
