/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef UTILFUNCTIONS_H
#define UTILFUNCTIONS_H

#define GET_PLAYER_I(x) (&g_player[x])
#define GET_PLAYER_E(x) (&g_player[ENTINDEX(x)])
#define GET_PLAYER(x)	GET_PLAYER_I(x)


#define GET_WEAPON(x) (g_weapon[x]);

#define GET_PROJECTILE_I(x)	(&g_projectiles[x]);
#define GET_PROJECTILE_E(x)	(&g_projectiles[ENTINDEX(x)]);
#define GET_PROJECTILE(x)	GET_PROJECTILE_I(x);

#define LINK_GAME(g,c,t) if (!strcmp(g,MF_GetModname())) { game=new c; game->type=t; }



#define TYPE_INT 1
#define TYPE_FLOAT 2
#define TYPE_STRING 3
#define TYPE_EDICT 4
#define TYPE_FORWARD 5
#define FORWARD_PARMS	FP_DONE
#define NATIVE_KEYVALUE_INT(parm,key)	\
if (!strcmpi(itemKeyName,key)) {		\
obj->##parm##=atoi(itemValue);			\
return 0;								\
};
#define NATIVE_KEYVALUE_BIT(parm,flag,key)	\
if (!strcmpi(itemKeyName,key)) {			\
if (atoi(itemValue))						\
	obj->##parm |= flag;					\
else										\
	obj->##parm &= ~##flag;					\
return 0;									\
};
#define NATIVE_KEYVALUE_FLOAT(parm,key)	\
if (!strcmpi(itemKeyName,key)) {		\
obj->##parm##=atof(itemValue);			\
return 0;								\
};
#define NATIVE_KEYVALUE_STRING(parm,key)	\
if (!strcmpi(itemKeyName,key)) {			\
obj->##parm##.assign(itemValue);			\
return 0;									\
};
#define NATIVE_KEYVALUE_EDICT(parm,key)		\
if (!strcmpi(itemKeyName,key)) {			\
obj->##parm##=INDEXENT2(atoi(itemValue));	\
return 0;									\
};
#define NATIVE_KEYVALUE_FORWARD(parm,key,params)							\
if (!strcmpi(itemKeyName,key)) {											\
	int ret;																\
	if (MF_AmxFindPublic(amx,itemValue,&ret) == AMX_ERR_NONE) {				\
	obj->##parm##=MF_RegisterSPForwardByName params;						\
		return 0;															\
	}																		\
	MF_Log("Function not found `%s`",itemValue);							\
	return 1;																\
};
			



void clearEntities(int del);
edict_t *UTIL_FindEntityInSphere( edict_t *pentEntity, const Vector &vecCenter, float flRadius );

void UTIL_Bubbles(int g_sModelIndexBubbles, Vector mins, Vector maxs, int count );
void UTIL_DecalTrace( TraceResult *pTrace, const char *decalName );
int UTIL_EntitiesInBox( edict_t **pList, int listMax, const Vector &mins, const Vector &maxs, int flagMask );
void UTIL_BloodDecalTrace( TraceResult *pTrace, int red = 1 );
edict_t *UTIL_FindEntityByClassname( edict_t *pStartEntity, const char *szName );
void UTIL_Bubbles(int g_sModelIndexBubbles, Vector mins, Vector maxs, int count, float height=0.0);

#endif // UTILFUNCTIONS_H

