/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#ifndef WEAPONMOD_H
#define WEAPONMOD_H


#include "sdk/amxxmodule.h" // AMXX Api
#include <sdk_util.h>
#include "String.h"
#include "List.h"

extern List<String> LogData;

#include "utilfunctions.h"
#include "weaponsmodconfig.h"
#include "CPlayer.h"
#include "CWeapon.h"
#include "CAutomatic.h"
#include "CPistol.h"
//#include "CShotgun.h"
//#include "CRifle.h"
//#include "CHandgrenade.h"
//#include "CLauncher.h"



#include "CWeaponinfo.h"

#include "CEntity.h"
#include "CProjectile.h"
#include "CExplosion.h"
#include "CGenericEntity.h"
extern CEntity	*g_entities[2048]; // such a crude method. :'(  (use 2048 or something much higher than 1024 because gpGlobals->maxEntities never seems to be... consistent)

extern int g_msgHook;

extern int			currentWeap;
extern CPlayer		g_player[33];
extern CWeapon		*g_weapon[MODULE_MAX_WEAPONS+32];

extern META_RES		alertRes;

extern class CMessageInfo	msg;



#include "CGameBase.h"
#include "CMessageInfo.h"

extern CGameBase		*game;


extern AMX_NATIVE_INFO	weapons_natives[];
extern AMX_NATIVE_INFO	projectiles_natives[];
extern AMX_NATIVE_INFO	misc_natives[];
extern AMX_NATIVE_INFO	explosion_natives[];
extern AMX_NATIVE_INFO	snark_natives[];
extern AMX_NATIVE_INFO	generic_natives[];
extern edict_t			*g_player_edicts[33];
extern int weaponInit;						// weapon_init forward
extern int currentWeap;						// How many weapons we have registered?
inline edict_t* INDEXENT2( int iEdictNum )
{ 
	if (iEdictNum >= 1 && iEdictNum <= gpGlobals->maxClients)
		return g_player_edicts[iEdictNum];

	else
		return (*g_engfuncs.pfnPEntityOfEntIndex)(iEdictNum); 
}

#define ENT_PRIVATE(x,y) (x *)g_entities[ENTINDEX(y)]

#define CHECK_ENTITY(x) if (x != 0 && (FNullEnt(INDEXENT2(x)) || x < 0 || x > gpGlobals->maxEntities)) { MF_LogError(amx,AMX_ERR_NATIVE,"Invalid entity: %d",x); return 0; }


enum WEAPON_ERROR {
	WEAPON_ERROR_NONE,
	WEAPON_ERROR_NO_FREE_WEAPONS,
	WEAPON_ERROR_INVALID_TYPE
};
enum WEAPON_STATE {
	WEAPON_INVALID,
	WEAPON_HOLSTERING,
	WEAPON_ATTACKING,
	WEAPON_COOLDOWN,
	WEAPON_IDLE,
	WEAPON_RELOADING
};

enum WEAPON_TYPE {
	WEAPONTYPE_INVALID,
	WEAPONTYPE_PISTOL,			// Semi-Automatic
	WEAPONTYPE_AUTOMATIC,		// Rifle type of weapons. (No need to keep clicking)
	WEAPONTYPE_SHOTGUN
};
#define WEAPONFLAG_OUTOFAMMO (1<<0)
#define WEAPONFLAG_SHOTGUNRELOAD (1<<1)


enum
{
	PROJECTILESTATE_INITIALIZING=		0,
	PROJECTILESTATE_FIRING,
	PROJECTILESTATE_EXPLOADING,
	PROJECTILESTATE_EXPIRED
};
enum
{
	PROJECTILEFLAG_FRIENDLYCONTACT=		(1<<0),
	PROJECTILEFLAG_ENEMYCONTACT=		(1<<1),
	PROJECTILEFLAG_TAKEDAMAGECONTACT=	(1<<2),
	PROJECTILEFLAG_NOGRAVITY=			(1<<3),
	PROJECTILEFLAG_NOTIMER=				(1<<4),
	PROJECTILEFLAG_HURTABLE=			(1<<5),
	PROJECTILEFLAG_LIGHT=				(1<<6)
};

void GameInit(void);

#define NATIVE(x) static cell AMX_NATIVE_CALL x (AMX *amx, cell *params)
#define CHECK_PARAMS(x) if (*params/sizeof(cell) != x ) { MF_LogError(amx,AMX_ERR_NATIVE,"Invalid number of parameters in %s (expected: %d got: %d)",__FUNCTION__,x,(*params/sizeof(cell))); return 1; }


#endif

