/* WTF Module
 *   Stuff
 *
 * by Steve Dudenhoeffer
 *
 * This file is part of WTF Module
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  In addition, as a special exception, the author gives permission to
 *  link the code of this program with the Half-Life Game Engine ("HL
 *  Engine") and Modified Game Libraries ("MODs") developed by Valve,
 *  L.L.C ("Valve"). You must obey the GNU General Public License in all
 *  respects for all of the code used other than the HL Engine and MODs
 *  from Valve. If you modify this file, you may extend this exception
 *  to your version of the file, but you are not obligated to do so. If
 *  you do not wish to do so, delete this exception statement from your
 *  version.
 */

#include "weaponmod.h"

enum {
	weapon_attackfunc = 0,
	weapon_viewmodel,
	weapon_playermodel,
	weapon_attackanim,
	weapon_drawanim,
	weapon_idleanim,
	weapon_rateoffire,
	weapon_drawtime,
	weapon_name
};
#define FIX_CURRENT_CLASS(x,v) if (x) { x->isStandardWeapon=FALSE; x->event_index=999; x->type=v; x->id=currentWeap; }
#define LINK_WEAPON_TO_CLASS(x,v) if (type==x) { g_weapon[currentWeap]=new v; FIX_CURRENT_CLASS(g_weapon[currentWeap],type); return currentWeap; }
static cell AMX_NATIVE_CALL register_weapon(AMX *amx, cell *params)
{
	int type=params[1];
	currentWeap++;
	if (currentWeap > (MODULE_MAX_WEAPONS + 32))
		return 0;
	LINK_WEAPON_TO_CLASS(weapontype_pistol,CPistol);
	LINK_WEAPON_TO_CLASS(weapontype_automatic,CAutomatic);
	return 0;
}
static cell AMX_NATIVE_CALL weapon_config(AMX *amx, cell *params)
{
	if (params[1] > currentWeap || params[1] < 0)
	{
		MF_Log("Invalid weapon index in weapon_config. (Got: %d)",params[1]);
		return 0;
	}
	CWeapon *obj = GET_WEAPON(params[1]);
	char *itemKeyName=NULL;
	char *itemValue=NULL;
	int len;
	itemKeyName=MF_GetAmxString(amx,params[2],0,&len);
	itemValue=MF_GetAmxString(amx,params[3],1,&len);
	
	NATIVE_KEYVALUE_FORWARD(func_attack,"attackforward",(amx,itemValue,FP_CELL,FP_DONE));
	NATIVE_KEYVALUE_STRING(viewmodel,"viewmodel");	
	NATIVE_KEYVALUE_STRING(weaponmodel,"playermodel");
	NATIVE_KEYVALUE_INT(anim_attack,"attackanim");
	NATIVE_KEYVALUE_INT(anim_draw,"drawanim");
	NATIVE_KEYVALUE_INT(anim_idle1,"idleanim");
	NATIVE_KEYVALUE_FLOAT(attack_delay,"rateoffire");
	NATIVE_KEYVALUE_FLOAT(deploy_delay,"deploydelay");
	NATIVE_KEYVALUE_STRING(name,"weaponname");
	
	MF_Log("Unknown weapon_config option `%s` (maybe updated module available?)",itemKeyName);
	return 1;
}

static cell AMX_NATIVE_CALL weapon_draw(AMX *amx, cell *params)
{
	if (params[1] < 1 || params[1] > gpGlobals->maxClients)
		return 0;
	if (params[2] < 33 || params[2] > currentWeap)
		return 0;
	CPlayer *player = GET_PLAYER_I(params[1]);
	player->Draw(params[2]);
	return 1;
}

AMX_NATIVE_INFO weapons_natives[] = {
	{ "register_weapon",	register_weapon		},
	{ "weapon_config",		weapon_config		},
	{ "weapon_draw",		weapon_draw			},
	{ NULL,					NULL				}
};

